<?php
/**
 * Background Mask Style - Diagonal Pills.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Diagonal_Pills
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Diagonal_Pills extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Diagonal Pills', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1731.17,1001.24h0a118.5,118.5,0,0,1-26.62-165.46l215.45-298V429L1556.62,931.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1920,24.4V0h-61.84L1526.62,458.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1565.72,0H0V1440H525l637.07-881.3a118.5,118.5,0,0,1,165.46-26.62h0a118.5,118.5,0,0,1,26.62,165.46L817.48,1440H897l295.15-408.3a118.5,118.5,0,0,1,165.46-26.62h0a118.51,118.51,0,0,1,26.62,165.46L1189.4,1440h78.65l264.06-365.3a118.5,118.5,0,0,1,165.46-26.62h0a118.51,118.51,0,0,1,26.62,165.46L1560.48,1440H1920V942.29l-23.38,32.34A118.49,118.49,0,0,1,1731.17,1001.24Z"/>',
					'portrait'  => '<path d="M1731.17,1001.24h0a118.5,118.5,0,0,1-26.62-165.46l215.45-298V429L1556.62,931.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1920,24.4V0h-61.84L1526.62,458.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1565.72,0H0V2560H1920V942.29l-23.38,32.34A118.49,118.49,0,0,1,1731.17,1001.24ZM480.91,1501.05l681.2-942.35a118.5,118.5,0,0,1,165.46-26.62h0a118.5,118.5,0,0,1,26.62,165.46L673,1639.89a118.5,118.5,0,0,1-165.46,26.62h0A118.5,118.5,0,0,1,480.91,1501.05Zm56.61,638.46h0a118.5,118.5,0,0,1-26.61-165.46l681.2-942.35a118.5,118.5,0,0,1,165.46-26.62h0a118.51,118.51,0,0,1,26.62,165.46L703,2112.89A118.5,118.5,0,0,1,537.52,2139.51Zm1186.67-926-261.55,361.81A118.49,118.49,0,0,1,1297.18,1602h0a118.5,118.5,0,0,1-26.61-165.45l261.54-361.81a118.5,118.5,0,0,1,165.46-26.62h0A118.51,118.51,0,0,1,1724.19,1213.54Z"/>',
					'square'    => '<path d="M1731.17,1001.24h0a118.5,118.5,0,0,1-26.62-165.46l215.45-298V429L1556.62,931.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1920,24.4V0h-61.84L1526.62,458.63a118.49,118.49,0,0,1-165.45,26.61h0a118.5,118.5,0,0,1-26.62-165.46L1565.72,0H0V1920H550l642.13-888.3a118.5,118.5,0,0,1,165.46-26.62h0a118.51,118.51,0,0,1,26.62,165.46L842.42,1920H1920V942.29l-23.38,32.34A118.49,118.49,0,0,1,1731.17,1001.24ZM673,1639.89a118.5,118.5,0,0,1-165.46,26.62h0a118.5,118.5,0,0,1-26.61-165.46l681.2-942.35a118.5,118.5,0,0,1,165.46-26.62h0a118.5,118.5,0,0,1,26.62,165.46Zm1051.21-426.35-261.55,361.81A118.49,118.49,0,0,1,1297.18,1602h0a118.5,118.5,0,0,1-26.61-165.45l261.54-361.81a118.5,118.5,0,0,1,165.46-26.62h0A118.51,118.51,0,0,1,1724.19,1213.54Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1354.19,697.54,817.48,1440H525l637.07-881.3a118.5,118.5,0,0,1,165.46-26.62h0A118.51,118.51,0,0,1,1354.19,697.54Zm7-212.3h0a118.49,118.49,0,0,0,165.45-26.61L1858.16,0H1565.72L1334.55,319.78A118.5,118.5,0,0,0,1361.17,485.24Zm-3.6,519.84h0a118.5,118.5,0,0,0-165.46,26.62L897,1440H1189.4l194.79-269.46A118.51,118.51,0,0,0,1357.57,1005.08Zm33.6-46.84h0a118.49,118.49,0,0,0,165.45-26.61L1920,429V24.4L1364.55,792.78A118.5,118.5,0,0,0,1391.17,958.24Zm306.4,89.84h0a118.5,118.5,0,0,0-165.46,26.62L1268.05,1440h292.43l163.71-226.46A118.51,118.51,0,0,0,1697.57,1048.08Zm7-212.3a118.5,118.5,0,0,0,26.62,165.46h0a118.49,118.49,0,0,0,165.45-26.61L1920,942.29V537.74Z"/>',
					'portrait'  => '<path d="M480.91,1501.05l681.2-942.35a118.5,118.5,0,0,1,165.46-26.62h0a118.51,118.51,0,0,1,26.62,165.46L673,1639.89a118.5,118.5,0,0,1-165.46,26.62h0A118.5,118.5,0,0,1,480.91,1501.05ZM1361.17,485.24h0a118.49,118.49,0,0,0,165.45-26.61L1858.16,0H1565.72L1334.55,319.78A118.5,118.5,0,0,0,1361.17,485.24Zm-3.6,519.84h0a118.5,118.5,0,0,0-165.46,26.62l-681.2,942.35a118.5,118.5,0,0,0,26.61,165.46h0A118.5,118.5,0,0,0,703,2112.89l681.21-942.35A118.51,118.51,0,0,0,1357.57,1005.08Zm33.6-46.84h0a118.49,118.49,0,0,0,165.45-26.61L1920,429V24.4L1364.55,792.78A118.5,118.5,0,0,0,1391.17,958.24Zm306.4,89.84h0a118.5,118.5,0,0,0-165.46,26.62l-261.54,361.81A118.5,118.5,0,0,0,1297.18,1602h0a118.49,118.49,0,0,0,165.46-26.61l261.55-361.81A118.51,118.51,0,0,0,1697.57,1048.08Zm7-212.3a118.5,118.5,0,0,0,26.62,165.46h0a118.49,118.49,0,0,0,165.45-26.61L1920,942.29V537.74Z"/>',
					'square'    => '<path d="M1354.19,697.54,673,1639.89a118.5,118.5,0,0,1-165.46,26.62h0a118.5,118.5,0,0,1-26.61-165.46l681.2-942.35a118.5,118.5,0,0,1,165.46-26.62h0A118.51,118.51,0,0,1,1354.19,697.54Zm7-212.3h0a118.49,118.49,0,0,0,165.45-26.61L1858.16,0H1565.72L1334.55,319.78A118.5,118.5,0,0,0,1361.17,485.24Zm-3.6,519.84h0a118.5,118.5,0,0,0-165.46,26.62L550,1920H842.42l541.77-749.46A118.51,118.51,0,0,0,1357.57,1005.08Zm33.6-46.84h0a118.49,118.49,0,0,0,165.45-26.61L1920,429V24.4L1364.55,792.78A118.5,118.5,0,0,0,1391.17,958.24Zm306.4,89.84h0a118.5,118.5,0,0,0-165.46,26.62l-261.54,361.81A118.5,118.5,0,0,0,1297.18,1602h0a118.49,118.49,0,0,0,165.46-26.61l261.55-361.81A118.51,118.51,0,0,0,1697.57,1048.08Zm7-212.3a118.5,118.5,0,0,0,26.62,165.46h0a118.49,118.49,0,0,0,165.45-26.61L1920,942.29V537.74Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1005.08,562.43a118.51,118.51,0,0,1,165.46-26.62L1920,1077.58V0H942.29l32.34,23.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L537.74,0H429L931.63,363.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L24.4,0H0V61.84L458.63,393.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L0,354.28V1440H1502.34l-1.29-.91L558.7,757.89a118.5,118.5,0,0,1-26.62-165.46h0a118.5,118.5,0,0,1,165.46-26.62L1639.89,1247a118.55,118.55,0,0,1-1.23,193H1920v-70L1031.7,727.89a118.5,118.5,0,0,1-26.62-165.46Zm43-340h0a118.51,118.51,0,0,1,165.46-26.62l361.81,261.55A118.49,118.49,0,0,1,1602,622.82h0a118.5,118.5,0,0,1-165.45,26.61L1074.7,387.89A118.5,118.5,0,0,1,1048.08,222.43Z"/>',
					'portrait'  => '<path d="M1001.24,188.83h0a118.5,118.5,0,0,1-165.46,26.62L537.74,0H429L931.63,363.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L24.4,0H0V61.84L458.63,393.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L0,354.28V2560H1920V1370L1031.7,727.89a118.5,118.5,0,0,1-26.62-165.46h0a118.51,118.51,0,0,1,165.46-26.62L1920,1077.58V0H942.29l32.34,23.38A118.49,118.49,0,0,1,1001.24,188.83ZM1639.89,1247a118.5,118.5,0,0,1,26.62,165.46h0a118.5,118.5,0,0,1-165.46,26.61L558.7,757.89a118.5,118.5,0,0,1-26.62-165.46h0a118.5,118.5,0,0,1,165.46-26.62ZM1213.54,195.81l361.81,261.55A118.49,118.49,0,0,1,1602,622.82h0a118.5,118.5,0,0,1-165.45,26.61L1074.7,387.89a118.5,118.5,0,0,1-26.62-165.46h0A118.51,118.51,0,0,1,1213.54,195.81Z"/>',
					'square'    => '<path d="M1001.24,188.83h0a118.5,118.5,0,0,1-165.46,26.62L537.74,0H429L931.63,363.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L24.4,0H0V61.84L458.63,393.38a118.49,118.49,0,0,1,26.61,165.45h0a118.5,118.5,0,0,1-165.46,26.62L0,354.28V1920H1920V1370L1031.7,727.89a118.5,118.5,0,0,1-26.62-165.46h0a118.51,118.51,0,0,1,165.46-26.62L1920,1077.58V0H942.29l32.34,23.38A118.49,118.49,0,0,1,1001.24,188.83ZM1639.89,1247a118.5,118.5,0,0,1,26.62,165.46h0a118.5,118.5,0,0,1-165.46,26.61L558.7,757.89a118.5,118.5,0,0,1-26.62-165.46h0a118.5,118.5,0,0,1,165.46-26.62ZM1213.54,195.81l361.81,261.55A118.49,118.49,0,0,1,1602,622.82h0a118.5,118.5,0,0,1-165.45,26.61L1074.7,387.89a118.5,118.5,0,0,1-26.62-165.46h0A118.51,118.51,0,0,1,1213.54,195.81Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M792.78,555.45,24.4,0H429L931.63,363.38a118.49,118.49,0,0,1,26.61,165.45h0A118.5,118.5,0,0,1,792.78,555.45Zm208.46-366.62h0A118.49,118.49,0,0,0,974.63,23.38L942.29,0H537.74l298,215.45A118.5,118.5,0,0,0,1001.24,188.83Zm73.46,199.06,361.81,261.54A118.5,118.5,0,0,0,1602,622.82h0a118.49,118.49,0,0,0-26.61-165.46L1213.54,195.81a118.51,118.51,0,0,0-165.46,26.62h0A118.5,118.5,0,0,0,1074.7,387.89Zm95.84,147.92a118.51,118.51,0,0,0-165.46,26.62h0a118.5,118.5,0,0,0,26.62,165.46L1920,1370V1077.58ZM458.63,393.38,0,61.84V354.28L319.78,585.45a118.5,118.5,0,0,0,165.46-26.62h0A118.49,118.49,0,0,0,458.63,393.38Zm1207.88,1019.1A118.5,118.5,0,0,0,1639.89,1247L697.54,565.81a118.51,118.51,0,0,0-165.46,26.62h0A118.5,118.5,0,0,0,558.7,757.89l942.35,681.2,1.29.91h136.32A118.18,118.18,0,0,0,1666.51,1412.48Z"/>',
					'portrait'  => '<path d="M697.54,565.81,1639.89,1247a118.5,118.5,0,0,1,26.62,165.46h0a118.5,118.5,0,0,1-165.46,26.61L558.7,757.89a118.5,118.5,0,0,1-26.62-165.46h0A118.51,118.51,0,0,1,697.54,565.81Zm-212.3-7h0a118.49,118.49,0,0,0-26.61-165.45L0,61.84V354.28L319.78,585.45A118.5,118.5,0,0,0,485.24,558.83Zm519.84,3.6h0a118.5,118.5,0,0,0,26.62,165.46L1920,1370V1077.58L1170.54,535.81A118.51,118.51,0,0,0,1005.08,562.43Zm-46.84-33.6h0a118.49,118.49,0,0,0-26.61-165.45L429,0H24.4L792.78,555.45A118.5,118.5,0,0,0,958.24,528.83Zm89.84-306.4h0a118.5,118.5,0,0,0,26.62,165.46l361.81,261.54A118.5,118.5,0,0,0,1602,622.82h0a118.49,118.49,0,0,0-26.61-165.46L1213.54,195.81A118.51,118.51,0,0,0,1048.08,222.43Zm-212.3-7a118.5,118.5,0,0,0,165.46-26.62h0A118.49,118.49,0,0,0,974.63,23.38L942.29,0H537.74Z"/>',
					'square'    => '<path d="M697.54,565.81,1639.89,1247a118.5,118.5,0,0,1,26.62,165.46h0a118.5,118.5,0,0,1-165.46,26.61L558.7,757.89a118.5,118.5,0,0,1-26.62-165.46h0A118.51,118.51,0,0,1,697.54,565.81Zm-212.3-7h0a118.49,118.49,0,0,0-26.61-165.45L0,61.84V354.28L319.78,585.45A118.5,118.5,0,0,0,485.24,558.83Zm519.84,3.6h0a118.5,118.5,0,0,0,26.62,165.46L1920,1370V1077.58L1170.54,535.81A118.51,118.51,0,0,0,1005.08,562.43Zm-46.84-33.6h0a118.49,118.49,0,0,0-26.61-165.45L429,0H24.4L792.78,555.45A118.5,118.5,0,0,0,958.24,528.83Zm89.84-306.4h0a118.5,118.5,0,0,0,26.62,165.46l361.81,261.54A118.5,118.5,0,0,0,1602,622.82h0a118.49,118.49,0,0,0-26.61-165.46L1213.54,195.81A118.51,118.51,0,0,0,1048.08,222.43Zm-212.3-7a118.5,118.5,0,0,0,165.46-26.62h0A118.49,118.49,0,0,0,974.63,23.38L942.29,0H537.74Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Diagonal_Pills();
