<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    diviflash
 * @subpackage diviflash/admin
 * @author     diviflash <admin@diviflash.com>
 */
class DiviFlash_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DiviFlash_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DiviFlash_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_register_style( 'df-admin-style', DIFL_ADMIN_DIR . 'css/admin.css', array(), $this->version );
		wp_enqueue_style('df-admin-style');
		wp_register_style( 'df-builder-styles', DIFL_PUBLIC_DIR . 'css/df-builder-styles.css', array(), $this->version );
		wp_enqueue_style('df-builder-styles');

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in DiviFlash_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The DiviFlash_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$screen = get_current_screen();

		if (isset($screen->base) && $screen->id === 'edit-et_pb_layout') {
			wp_register_script( 'df-shortcode-copy', DIFL_ADMIN_DIR . 'js/df-shortcode-copy.js', array(), $this->version, true );
			wp_enqueue_script('df-shortcode-copy');
		}

		wp_register_script( 'df-dashboard', DIFL_ADMIN_DIR . 'js/df-dashboard.js', array(), $this->version, true );
		wp_enqueue_script('df-dashboard');
		$inactive_module = Diviflash_dashboard::module_manager_obj()->get_default_inactive_modules();
		wp_localize_script('df-dashboard', 'ajax_var', array(
			'url' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('diviflash_save_dashboard'),
			'inactive_modules' => $inactive_module
		));

	}

}
