<?php 
defined( 'ABSPATH' ) || die();

/**
 * The file is responsible for the license setttings
 * and automatic updates
 */
if(file_exists(DIFL_ADMIN_DIR_PATH . '/license/df_license.php')) {
    require_once ( DIFL_ADMIN_DIR_PATH . '/license/df_license.php');
} 
require_once ( DIFL_ADMIN_DIR_PATH . '/df-panel-init.php');

class Diviflash_dashboard {
    const PAGE_SLUG = 'diviflash-dashboard';

    const LICENSE_PAGE_SLUG = 'diviflash-license';

    const MODULES_PAGE_SLUG = 'diviflash-modules';

    const WIDGETS_NONCE = 'diviflash_save_dashboard';
    static $menu_slug = '';
    public $module;
    public function __construct() {
        add_action( 'admin_menu', [$this , 'diviflash_menu' ], 21 );
        add_action( 'wp_ajax_' . self::WIDGETS_NONCE, [ $this , 'save_data' ] );
        add_action( 'difl_save_inactive_modules', [ $this , 'save_modules_data' ] );
        add_filter( 'plugin_action_links_' . DIFL_BASENAME, [$this, 'df_add_action_links'] , 10, 1);
   
    }
    /**
     * Add Two links Settings and Activate License at just after Deactivate link at plugin list page. 
     * plugin_action_links_ filter callback function
     * 
     * @param  Array existing action links
     * @return Array all action links 
     */
    public function df_add_action_links ( $actions ) {
        $dashboard_link = esc_url( 'admin.php?page=' . self::PAGE_SLUG );
        $settings  = array( '<a href="' . admin_url( $dashboard_link ) .  '"> '. __('Settings', 'divi_flash') .' </a>',);       
        $actions = array_merge( $actions, $settings );
        
        if(class_exists('DF_SL_Plugin_Updater')) {
            $license_link = array('<a href="' .  esc_url( 'admin.php?page=' . self::LICENSE_PAGE_SLUG ) .  '"> '. __('License', 'divi_flash') .' </a>',);
            $actions = array_merge( $actions, $license_link );
        }
        
        return $actions;
    }
    /**
     * Class object 
     * 
     * @return Object
     */
    public function module_obj() {
        return new Diviflash_Module_Manage();
    }
    public static function module_manager_obj() {
        return new Diviflash_Module_Manage();
    }
    /**
     * Save after Ajax call
     * ajax action name diviflash_save_dashboard
     * do_action call difl_save_inactive_modules 
     * 
     * @return String Json string 
     */
    public function save_data() {
        
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( ! check_ajax_referer( self::WIDGETS_NONCE, 'diviflash_save_dashboard' ) ) {
            wp_send_json_error();
        }

        $modules_data = ! empty( $_POST['modules'] ) ? sanitize_text_field($_POST['modules']): ''; 
        do_action( 'difl_save_inactive_modules', $modules_data ); 
        wp_send_json_success();
    }

    /**
     * Save module list with json in DB
     * 
     * @param  json  generate ( df-dashboard.js) after Dashboard Save button
     * @return boolean  
     */ 
    public function save_modules_data( $modules ) {
        $module = new Diviflash_Module_Manage();
        $active_modules = ! empty(  $modules ) ?  explode(",",$modules) : [];
        $all_modules = $module->all_modules_map(); 
        $all_parent_modules = array_column($all_modules, 'parent');
        $inactive_modules = array_values( array_diff(  $all_parent_modules , $active_modules ) );    
       // $module->save_inactive_modules( $inactive_modules );
        $module->save_active_modules( $active_modules );
    }

    /**
     * Check each module active on not
     * 
     * @param  String  Module name 
     * @return boolean  
     */ 
    public function check_module_active_status( $module_name='' ) {
        $all_modules = $this->module_obj()->all_modules_map();
        $all_parent_modules = array_column( $all_modules, 'parent' );
        $inactive_module = json_decode($this->module_obj()->get_inactive_modules() ); 
        
        if (in_array( $module_name, $all_parent_modules ) && !in_array( $module_name, $inactive_module )) {
            return true;
        }
        return false;
    }
  
     /**
     * DiviFlash main menu
     * DiviFlash Sub menu with licence
     */ 
    public function diviflash_menu() {
        add_menu_page( 
            __( 'DiviFlash Dashboard', 'divi-flash' ),
            __( 'DiviFlash', 'divi-flash' ),
            'manage_options',
            self::PAGE_SLUG,
            [ $this, 'render_dashboard' ],
            DIFL_ADMIN_DIR . 'img/diviflash.png',
            100
        ); 
        add_submenu_page(
            self::PAGE_SLUG,
            __( 'DiviFlash Dashboard', 'divi-flash' ),
            __( 'Dashboard', 'divi-flash' ),
            'manage_options',
            self::PAGE_SLUG,
            [ $this, 'render_dashboard' ]
        );
        add_submenu_page(
            self::PAGE_SLUG,
            __( 'DiviFlash Modules', 'divi-flash' ),
            __( 'Modules', 'divi-flash' ),
            'manage_options',
            self::MODULES_PAGE_SLUG,
            [ $this, 'render_modules' ]
        );
        // licese page menu
        if(file_exists(DIFL_ADMIN_DIR_PATH . '/license/df_license.php')) { 
            add_submenu_page(
                self::PAGE_SLUG,
                __( 'DiviFlash License', 'divi-flash' ),
                __( 'License', 'divi-flash' ),
                'manage_options',
                self::LICENSE_PAGE_SLUG,
                [$this, 'render_license']
            );
        }
    }

    /**
     * All Dashboard related page include using this function
     * 
     * @param  String $template php file name after "dashboard-" 
     * @param Array $data any custom/extra data that use at template page. It is optional
     */ 
    public function load_template( $template , $data = array() ) {

        $file = DIFL_MAIN_DIR . '/template/admin/' . $template . '.php';
        if ( is_readable( $file ) ) {

            if(!empty($data)){
                extract($data); // phpcs:ignore WordPress.PHP.DontExtract
            }
        
            include( $file );
        }
    }

    /**
     * Include License page
     *
     */ 
    public function render_license() {
        
        df_license_page();  
    }

    /**
     * Include Module Controll page
     *
     */ 
    public function render_modules() {
        $data['all_modules'] =$this->module_obj()->all_modules_map();
        $get_inactive_module = json_decode($this->module_obj()->get_inactive_modules());
        $get_active_module = json_decode($this->module_obj()->get_active_modules());
        $get_default_inactive_module = $this->module_obj()->get_default_inactive_modules();
        //$data['inactive_module'] = $get_inactive_module; //array_merge($get_inactive_module ,$get_default_inactive_module);
        $data['active_module'] = $get_active_module; //array_merge($get_inactive_module ,$get_default_inactive_module);
        $this->load_template( 'dashboard-modules' , $data );   
    }

     /**
     * Include Dashboard page
     *
     */ 
    public function render_dashboard() {
        echo '<div id="diviflash-plugin-dashboard"></div>';
    }

}
new Diviflash_dashboard();