<?php
defined( 'ABSPATH' ) || die();
/**
 * Add an entry point for the gutenberg
 * settings page for the plugin.
 *
 * @return void
 */
function diviflash_plugin_admin_scripts() {
	$dir = __DIR__;

	if(get_current_screen()->base != 'toplevel_page_diviflash-dashboard') return;

	$df_dashboard_asset_path = "$dir/df-panel/index.asset.php";
	if ( ! file_exists( $df_dashboard_asset_path ) ) {
		return;
	}

	// dashboard script
	$df_dashboard_js     = 'df-panel/index.js';
	$df_dashboard_script_asset = require( $df_dashboard_asset_path );
	wp_enqueue_script(
		'diviflash-plugin-admin-editor',
		plugins_url( $df_dashboard_js, __FILE__ ),
		$df_dashboard_script_asset['dependencies'],
		$df_dashboard_script_asset['version']
	);
	wp_set_script_translations( 'diviflash-plugin-block-editor', 'divi_flash' );

	wp_localize_script('diviflash-plugin-admin-editor', 'df_dashboard', array(
		'nonce' => wp_create_nonce('df_dashboard_settings')
	));

	// dashboard css
	$df_dashboard_css = 'df-panel/index.css';
	wp_enqueue_style(
		'diviflash-plugin-admin',
		plugins_url( $df_dashboard_css, __FILE__ ),
		['wp-components'],
		filemtime( "$dir/$df_dashboard_css" )
	);
}
add_action( 'admin_enqueue_scripts', 'diviflash_plugin_admin_scripts', 10 );

/**
 * Register diviflash settings for the
 * dashboard.
 *
 * @return void
 */
function diviflash_plugin_register_settings() {

	// general settings
	register_setting (
		'diviflash_plugin_dashboard',
		'df_general_svg_support',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> false
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_general_json_support',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> false
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_general_library_shortcode',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> true
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_general_acf_field_support',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> false
		]
	);

	// menu settings
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_bottom_line',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> false
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_bottom_line_color',
		[
			'show_in_rest'	=> true,
			'type'			=> 'string',
			'default'		=> '#333333'
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_bottom_line_height',
		[
			'show_in_rest'	=> true,
			'type'			=> 'integer',
			'default'		=> 1
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_bottom_line_distance',
		[
			'show_in_rest'	=> true,
			'type'			=> 'number',
			'default'		=> 0
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_bottom_line_distance_fixed',
		[
			'show_in_rest'	=> true,
			'type'			=> 'number',
			'default'		=> 0
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_line_width',
		[
			'show_in_rest'	=> true,
			'type'			=> 'string',
			'default'		=> 'full'
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_line_animation',
		[
			'show_in_rest'	=> true,
			'type'			=> 'string',
			'default'		=> 'left'
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_hide_bottom_border',
		[
			'show_in_rest'	=> true,
			'type'			=> 'boolean',
			'default'		=> false
		]
	);
	register_setting (
		'diviflash_plugin_dashboard',
		'df_menu_item_distance',
		[
			'show_in_rest'	=> true,
			'type'			=> 'integer',
			'default'		=> 22
		]
	);
}
add_action( 'init', 'diviflash_plugin_register_settings', 10 );

/**
 * All dashboard settings value for Import/Export
 * 
 * @return Array
 */
function df_all_dashboard_settings_key() {
	return array(
		'df_general_svg_support',
		'df_general_json_support',
		'df_general_library_shortcode',
		'df_general_acf_field_support',
		'df_menu_bottom_line',
		'df_menu_bottom_line_color',
		'df_menu_bottom_line_height',
		'df_menu_bottom_line_distance',
		'df_menu_bottom_line_distance_fixed',
		'df_menu_line_width',
		'df_menu_line_animation',
		'df_menu_hide_bottom_border',
		'df_menu_item_distance'
	);
}

/**
 * Export dashboard settings
 * Handle Ajax Request
 * 
 * @return Json
 */
add_action('wp_ajax_df_export_dashboard_settings', 'df_export_dashboard_settings');
add_action('wp_ajax_nopriv_df_export_dashboard_settings', 'df_export_dashboard_settings');

function df_export_dashboard_settings() {

	if (!isset($_POST['nonce']) && !wp_verify_nonce( sanitize_text_field($_POST['nonce']), 'df_dashboard_settings' )) {
        wp_die();
    }

	$settings_key = df_all_dashboard_settings_key();
	$settings_object = array();

	$settings_object['context'] = "df_settings";

	foreach($settings_key as $key) {
		$settings_object[$key] = get_option($key);
	}

	wp_send_json_success(wp_json_encode($settings_object));
}
/**
 * Import dashboard settings
 * Handle Ajax Request and update all the settings
 * 
 * @return Json
 */
add_action('wp_ajax_df_import_dashboard_settings', 'df_import_dashboard_settings');
add_action('wp_ajax_nopriv_df_import_dashboard_settings', 'df_import_dashboard_settings');

function df_import_dashboard_settings() {

	if (!isset($_POST['nonce']) && !wp_verify_nonce( sanitize_text_field($_POST['nonce']), 'df_dashboard_settings' )) {
        wp_die();
    }

	$settings_key = df_all_dashboard_settings_key();

	$settings = isset($_POST['settings']) ? json_decode(stripslashes(sanitize_text_field($_POST['settings']))) : '';

	foreach($settings as $key=>$value) {
		if(in_array($key, $settings_key)) {
			update_option($key, $value);
		}
	}

	wp_send_json_success('success');
}




