<?php
    /*
    Plugin Name: DiviFlash
    Plugin URI:  http://www.diviflash.com
    Description: Module pack for Divi
    Version:     1.2.6
    Author:      DiviFlash
    Author URI:  http://www.diviflash.com
    License:     GPL2
    License URI: https://www.gnu.org/licenses/gpl-2.0.html
    Text Domain: divi_flash
    Domain Path: /languages
    */

    if(!defined('DIFL_MAIN_DIR')) {
        define('DIFL_MAIN_DIR', __DIR__);
    }
    if(!defined('DIFL_ADMIN_DIR')) {
        define('DIFL_ADMIN_DIR', trailingslashit( plugin_dir_url( __FILE__ ) ) . 'admin/');
    }
    if(!defined('DIFL_ADMIN_DIR_PATH')) {
        define('DIFL_ADMIN_DIR_PATH', plugin_dir_path( __FILE__ ) . 'admin/');
    }
    if(!defined('DIFL_PUBLIC_DIR')) {
        define('DIFL_PUBLIC_DIR', trailingslashit( plugin_dir_url( __FILE__ ) ) . 'public/');
    }
    if(!defined('DIFL_PUBLIC_DIR_PATH')) {
        define('DIFL_PUBLIC_DIR_PATH', plugin_dir_path( __FILE__ ) . 'public/');
    }
    if(!defined('DIFL_MAIN_FILE_PATH')) {
        define('DIFL_MAIN_FILE_PATH', __FILE__);
    }
    if(!defined('DIFL_VERSION')) {
        define('DIFL_VERSION','1.2.6');
    }

    if ( ! defined( 'DIFL_BASENAME' ) ) {
        define( 'DIFL_BASENAME', plugin_basename( __FILE__ ) );
    }

    /**
     * The core plugin class that is used to define internationalization,
     * admin-specific hooks, and public-facing site hooks.
     */
    require plugin_dir_path( __FILE__ ) . 'includes/class-diviflash-init.php';
    /**
     * Begins execution of the plugin.
     *
     * Since everything within the plugin is registered via hooks,
     * then kicking off the plugin from this point in the file does
     * not affect the page life cycle.
     *
     */
    function run_diviflash() {

        $plugin = new DiviFlashInit();
        $plugin->run();

        if( get_option( 'difl_inactive_modules' ) ) { // if upgrade from v1.1.2
            update_option( 'df_inactive_modules', get_option( 'difl_inactive_modules' ) ); // clone from another key.
            delete_option( 'difl_inactive_modules' ); //clean up previouse option key
        }

        if ( get_option('df_inactive_modules') ){ // upgrade from v1.1.5
            $get_all_modules = Diviflash_dashboard::module_manager_obj()->get_all_modules();
            $get_default_inactive_module = json_decode(Diviflash_dashboard::module_manager_obj()->get_inactive_modules());
            $diff_module = array_diff(array_keys($get_all_modules) , $get_default_inactive_module );
            $default_inactive_latest_array = array_filter(Diviflash_dashboard::module_manager_obj()->get_all_modules(), function ($var) {
                if(isset($var['release_version'])){
                    return $var['release_version'] === DIFL_VERSION && $var['is_default_active'] === false;
                }
            });
            $default_inactive_latest_array_modules = array_keys($default_inactive_latest_array);
            $update_modules = array_diff($diff_module , $default_inactive_latest_array_modules );

            update_option( 'df_active_modules', wp_json_encode(array_values($update_modules)) );
            update_option( 'df_inactive_modules_added', DIFL_VERSION );
            delete_option('df_inactive_modules'); //clean up previouse option key
        }

        if ( ! get_option('df_active_modules') ){	 // if First time purchase
            update_option( 'df_active_modules', wp_json_encode(Diviflash_dashboard::module_manager_obj()->get_default_active_modules()) );
            update_option( 'df_inactive_modules_added', DIFL_VERSION );
        }

    }

    run_diviflash();

    /**
     * Auto-deactivate DiviFlash Plugin if inactive Divi/Extra child or parent theme or Divi Builder
     *
     */
    function df_deactivate_if_theme_builder_uses() {
        // Don't do anything if the user isn't logged in
        if ( ! is_user_logged_in() ) {
            return;
        }

        if (class_exists('ET_Core_API_ElegantThemes')) {
            return;
        }

        if ( current_user_can( 'activate_plugins' ) ) {
            add_action( 'admin_notices', 'df_auto_deactivate_notice' );
            add_action( 'admin_init', 'df_auto_deactivate' );
        }
    }
    add_action( 'init', 'df_deactivate_if_theme_builder_uses' );

    /**
     * Deactivate this plugin
     *
     */
    function df_auto_deactivate() {
        deactivate_plugins( DIFL_BASENAME );
    }

    /**
     * Print a WP Admin notice when DiviFlash has deactivated
     *
     */
    function df_auto_deactivate_notice() {
        $classes = 'notice notice-warning is-dismissible';
        $message = __( 'First You should activate Divi/Extra theme or Divi Builder to use diviflash.', 'et_builder' );

        printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $classes ), esc_html( $message ) );

        if ( isset( $_GET['activate'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification
            unset( $_GET['activate'] ); // phpcs:ignore WordPress.Security.NonceVerification
        }
    }