<?php

/**
 * CPT Image
 * 
 * @param Array $settings
 */
function df_cpt_image($settings = array(), $builder = false) {
    global $post;
    
    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';
    $size_array = array(
        'large' => array(1080, 675),
        'mid-hr' => array(350, 450),
        'mid' => array(400, 250),
        'mid-squ' => array(400, 400),
        'sm-squ' => array(300, 300),
        'original' => 'original'
    );
 
    $image_overlay = $settings['overlay'];
    $classes = '';
    $overlay = '';
    $overlay_icon = '';
    $post_format    = et_pb_post_format();
    $width          = (int) apply_filters( 'et_pb_blog_image_width', $size_array[$settings['image_size']][0] );
    $height         = (int) apply_filters( 'et_pb_blog_image_height', $size_array[$settings['image_size']][1] );
 
    $titletext      = get_the_title();
    $alttext        = get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true );
    $thumbnail      = get_thumbnail( $width, $height, 'df-cpt-image', $alttext, $titletext, false, 'Blogimage' );
    $thumb          = $thumbnail['thumb'];
  
    $post_thumbnail = get_the_post_thumbnail();

    if( $size_array[$settings['image_size']] !== 'original' && !empty($thumb) ) {
        $post_thumbnail = print_thumbnail( $thumb, $thumbnail['use_timthumb'], $titletext, $width, $height, '', false );
    }

    // overlay
    $classes = sprintf('df-hover-effect %1$s',
        $settings['image_scale']
    );
    if($image_overlay === 'on') {
        if($settings['overlay_icon'] === 'on') {
            $overlay_icon = sprintf('<span class="df-icon-wrap">
                    <span class="df-icon-overlay %2$s">%1$s</span>
                </span>', 
                esc_attr(et_pb_process_font_icon($settings['overlay_font_icon'])),
                $settings['overlay_icon_reveal']
            );
        }
        $classes .= ' has_overlay';
        $overlay = '<span class="df-overlay"></span>';
    }
  
    et_divi_post_format_content();

    if ( 'video' === $post_format && false !== ( $first_video = et_get_first_video() ) ) :
        $video_overlay = has_post_thumbnail() ? sprintf(
            '<div class="et_pb_video_overlay" style="background-image: url(%1$s); background-size: cover;">
                <div class="et_pb_video_overlay_hover">
                    <a href="#" class="et_pb_video_play"></a>
                </div>
            </div>',
            $thumb
        ) : '';
        
        if(empty($first_video)) return;
        echo sprintf(
            '<div class="df-item-wrap df-cpt-image-wrap %3$s %4$s">
                <div class="et_main_video_container">
                    %1$s
                    %2$s
                </div>
            </div>',
            et_core_esc_previously( $video_overlay ),
            et_core_esc_previously( $first_video ),
            esc_attr($settings['class']),
            esc_attr($module_class)
        );
    else:
        if(!empty($thumb)) {
            echo sprintf('<div class="df-item-wrap df-cpt-image-wrap %3$s %7$s">
                    %8$s
                    <a class="%4$s" href="%2$s">%1$s%5$s%6$s</a>
                </div>', 
                et_core_esc_previously($post_thumbnail), 
                esc_url(get_the_permalink()),
                esc_attr($settings['class']),
                esc_attr($classes),
                et_core_esc_previously($overlay),
                et_core_esc_previously($overlay_icon),
                esc_attr($module_class),
                et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
            );
        } elseif (empty($thumb) && $builder === true) {
            echo sprintf('<div class="df-item-wrap df-cpt-image-wrap df-empty-element %1$s %2$s"></div>', 
                esc_attr($settings['class']),
                esc_attr($module_class)
            );
        };
        
    endif;
}


/**
 * CPT Date
 * 
 * @param Array $settings
 */
function df_cpt_date($settings = array(), $builder = false) {
    global $post;


    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    echo sprintf('<span class="df-item-wrap df-cpt-date-wrap %2$s %4$s">%5$s %3$s %1$s</span>', 
        get_the_date($settings['date_format']),
        esc_attr($settings['class']),
        et_core_esc_previously(df_cpt_render_icon_image($settings)),
        esc_attr($module_class),
        et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
    );
}
/**
 * CPT Author
 * 
 * @param Array $settings
 */
function df_cpt_author($settings = array(), $builder = false) {
    global $post;

    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    $height = '';
    $min_height = '';

    if($settings['show_author_image'] === 'on') {
        $height = $settings['author_image_size'] . 'px';
        $min_height = ' style=height:'.$settings['author_image_size'].'px;';
    }

    $author_image = 'on' === $settings['show_author_image'] ? sprintf(
        '<a href="%2$s" class="author-image">%1$s</a> ',
        get_avatar( get_the_author_meta( 'ID' ), $settings['author_image_size'] ),
        get_author_posts_url( get_the_author_meta( 'ID' ) )
    ) : '';

    $author_link = 'on' === $settings['show_author_image'] && 'on' === $settings['hide_author_text'] ? 
        '' : et_pb_get_the_author_posts_link();
    
    echo sprintf('<span class="df-item-wrap df-cpt-author-wrap %2$s %6$s">%7$s %4$s %3$s %1$s</span>', 
        et_core_esc_previously($author_link),
        esc_attr($settings['class']),
        et_core_esc_previously($author_image),
        et_core_esc_previously(df_cpt_render_icon_image($settings)),
        et_core_esc_previously($min_height),
        esc_attr($module_class),
        et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
    );
}
/**
 * CPT Title
 * 
 * @param Array $settings
 */
function df_cpt_title($settings = array(), $builder = false) {    
    global $post;

    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    if(!empty(get_the_title())) {
        echo sprintf('<div class="df-item-wrap df-cpt-title-wrap %4$s %5$s">
                %6$s
                <%3$s class="df-cpt-title">
                    <a href="%2$s">
                        %1$s
                    </a>
                </%3$s>     
            </div>', 
            wp_kses_post(get_the_title()), 
            esc_url(get_the_permalink()), 
            esc_attr($settings['title_tag']),
            esc_attr($settings['class']),
            esc_attr($module_class),
            et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
        );
    } elseif (empty(get_the_title()) && $builder === true) {
        echo sprintf('<div class="df-item-wrap df-cpt-title-wrap df-empty-element %1$s %2$s"></div>', 
            esc_attr($settings['class']),
            esc_attr($module_class)
        );
    }
    
}

/**
 * CPT Content
 * 
 * @param Array $settings
 * @param Boolean
 */
function df_cpt_content($settings = array(), $builder = false) {
    global $post;

   // $post_content = et_strip_shortcodes( et_delete_post_first_video( get_the_content() ), true );
    $post_content = et_strip_shortcodes( et_delete_post_first_video( get_the_content() ), true );
    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    echo '<div class="df-item-wrap df-cpt-content-wrap '.esc_attr($settings['class']) . ' ' . esc_attr($module_class) .'">';
        echo et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ));
        if('content' === $settings['post_content']) {
            global $more;

            // page builder doesn't support more tag, so display the_content() in case of post made with page builder
            if ( et_pb_is_pagebuilder_used( get_the_ID() ) ) {
                $more = 1; // phpcs:ignore WordPress.WP.GlobalVariablesOverride

                echo et_core_intentionally_unescaped( apply_filters( 'the_content', $post_content ), 'html' );

            } else {
                $more = null; // phpcs:ignore WordPress.WP.GlobalVariablesOverride
                echo et_core_intentionally_unescaped( apply_filters( 'the_content', et_delete_post_first_video( get_the_content( esc_html__( 'read more...', 'et_builder' ) ) ) ), 'html' );
            }
        } elseif('excerpt' === $settings['post_content']) {
            if ( has_excerpt() && 'on' === $settings['use_post_excrpt']) {
                $excerpt = get_the_excerpt();
                $excerpt = substr( $excerpt , 0, intval($settings['excerpt_length']));
               
                if (strlen($excerpt)>=intval($settings['excerpt_length'])) {
                    $excerpt =  $excerpt.'...';        
                }
                $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
                echo $excerpt;

            } else {
                echo et_core_intentionally_unescaped( wpautop( et_delete_post_first_video( strip_shortcodes( truncate_post( intval($settings['excerpt_length']), false, '', true ) ) ) ), 'html' );
            }
        }
    echo '</div>';
}


/**
 * CPT Read More Button
 * 
 * @param Array $settings
 * @param Boolean
 * @return void
 */
function df_cpt_button($settings = array(), $builder = false) {
    global $post;

    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    $output = sprintf('<div class="df-item-wrap df-cpt-button-wrap %2$s %5$s">
            %6$s
            <a class="df-cpt-read-more" href="%1$s"><span>%3$s</span> %4$s</a>
        </div>', 
        get_the_permalink(),
        esc_attr($settings['class']),
        esc_html($settings['read_more_text']),
        df_cpt_render_icon_image($settings),
        esc_attr($module_class),
        et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
    );
    
    echo et_core_esc_previously($output);
}

/**
 * CPT element divider
 * 
 * @param Array $settings
 * @param Boolean
 * @return void
 */
function df_cpt_divider($settings = array(), $builder = false) {
    global $post;

    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    echo sprintf(
        '<div class="df-item-wrap %1$s %2$s">
            %3$s
            <span class="df-cpt-ele-divider"></span>
        </div>',
        esc_attr($settings['class']),
        esc_attr($module_class),
        et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
    );
}

/**
 * CPT Custom Text
 * 
 * @param Array $settings
 * @param Boolean
 */
function df_cpt_custom_text($settings = array(), $builder = false) {
    global $post;

    if( $settings['custom_text'] === '' ) return; 
    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    echo sprintf('<span class="df-item-wrap df-cpt-custom-text %2$s %3$s">%4$s %1$s</span>', 
        esc_html__($settings['custom_text'], 'divi_flash'),
        esc_attr($settings['class']),
        esc_attr($module_class),
        et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
    );
}

/**
 * CPT taxonomies
 * 
 * @param Array $settings
 * @param Boolean 
 * @return String
 */
function df_cpt_taxonomy($settings = array(), $builder = false) {
    global $post;

    $module_class = isset($settings['module_vb_class']) ? $settings['module_vb_class'] : '';

    if ($settings['taxonomy'] === 'select_tax') return;
    if(!taxonomy_exists($settings['taxonomy'])) return;
    $taxonomies = get_the_term_list($post->ID, $settings['taxonomy'], '', ', ');

    if(!empty($taxonomies)) {
        echo sprintf('<span class="df-item-wrap df-cpt-taxonomies %1$s %2$s">
                %5$s %4$s %3$s
            </span>',
            esc_attr($settings['class']),
            esc_attr($module_class),
            wp_kses_post($taxonomies),
            et_core_esc_previously(df_cpt_render_icon_image($settings)),
            et_core_esc_previously(df_print_background_mask_and_pattern_dynamic_modules( $settings ))
        );
    } elseif(empty($taxonomies) && $builder === true) {
        echo sprintf('<span class="df-item-wrap df-cpt-taxonomies df-empty-element %1$s %2$s"></span>',
            esc_attr($settings['class']),
            esc_attr($module_class)
        );
    }
    

}

/**
 * CPT image as background
 * 
 * @param String $use_image_as_background
 * @return String
 */
function df_cpt_image_as_background($use_image_as_background) {
    global $post;
    // use_image_as_background
    if($use_image_as_background === 'on' && !empty(get_the_post_thumbnail_url($post->ID))) {
        return sprintf('style="background-image:url(%1$s); 
            background-size: cover; 
            background-repeat: no-repeat;
            background-position: center;
            background-origin: border-box;"', 
            get_the_post_thumbnail_url($post->ID)
        );
    }
}

/**
 * Render markup for acf fields
 * 
 * Supported fields: 'text', 'number', 'textarea', 'range', 'email', 'url', 'image', 'select', 'date_picker', 'wysiwyg'
 * 
 * @param Array $settings
 * @param Boolean
 * @return String
 */
function df_cpt_acf_fields($settings = array(), $builder = false) {
   df_acf_fields_function($settings , $builder);
}

/**
 * CPTGrid: Render Posts for CPTGrid Module on VB
 * 
 */
add_action('wp_ajax_df_cpt_grid', 'df_cpt_grid');
function df_cpt_grid() {
    global $paged, $post, $wp_query, $wp_filter, $__et_blog_module_paged;

    // create the display gallery code
    $data = json_decode(file_get_contents('php://input'), true);
    if (! wp_verify_nonce( $data['et_admin_load_nonce'], 'et_admin_load_nonce' )) {
        wp_die();
    }

    $cpt_items = isset($data['cptItems']) ? $data['cptItems'] : array();
    
    $cpt_item_inner = isset($cpt_items['inner']) ? $cpt_items['inner'] : array();
    $cpt_item_outer = isset($cpt_items['outer']) ? $cpt_items['outer'] : array();

    $post_type = isset($data['post_type']) ? $data['post_type'] : ' project';
    $posts_number = isset($data['posts_number']) ? intval($data['posts_number']) : 10;
    $post_display = isset($data['post_display']) ? $data['post_display'] : 'recent';
    $orderby = isset($data['orderby']) ? $data['orderby'] : '1';
    $selected_taxonomy = isset($data['selected_taxonomy']) ? $data['selected_taxonomy'] : '';
    $selected_terms = isset($data['selected_terms']) ? $data['selected_terms'] : '';
    $offset_number = isset($data['offset_number']) ? $data['offset_number']: '0';
    $layout = isset($data['layout']) ? $data['layout'] : 'grid';
    $use_image_as_background = isset($data['use_image_as_background']) ? $data['use_image_as_background'] : 'off';
    $use_background_scale = isset($data['use_background_scale']) ? $data['use_background_scale'] : 'off';
    $equal_height = isset($data['equal_height']) ? $data['equal_height'] : 'off';
    $show_pagination = isset($data['show_pagination']) ? $data['show_pagination'] : 'off';
    $use_number_pagination = isset($data['use_number_pagination']) ? $data['use_number_pagination'] : 'off';
    $older_text = isset($data['older_text']) ? $data['older_text'] : 'Older Entries';
    $newer_text = isset($data['newer_text']) ? $data['newer_text'] : 'Next Entries';
    $use_current_loop = $data['use_current_loop'];
    $post_type_arch = $data['post_type_arch'];
    $use_icon_only_at_pagination = isset($data['use_icon_only_at_pagination']) ? $data['use_icon_only_at_pagination'] : 'off';

    $post_type = $use_current_loop === 'on' ? $post_type_arch : $post_type;

    $query_args = array(
        'posts_per_page' => $posts_number,
        'post_status'    => array( 'publish' ),
        'post_type'      => $post_type,
    );

    if(empty($post_type) || $post_type == 'select') {
        wp_send_json_success('<h2 style="background:#eee; padding: 10px 20px;">Please select a <strong>Post Type</strong>.</h2>');
        return;
    }

    // by taxonomy
    if( 'by_tax' === $post_display && '' !== $selected_terms ) {
        $query_args['tax_query'] = array( //phpcs:ignore WordPress.DB.SlowDBQuery
            'relation' => 'AND',
            array(
                'taxonomy'  => $selected_taxonomy,
                'field'     => 'term_id',
                'terms'     => explode(',', $selected_terms)
            )
        );
    }
    // orderby
    if ( 'recent' == $post_display) {
        if ( '3' === $orderby ) {
            $query_args['orderby'] = 'rand';
        } else if('2' === $orderby) {
            $query_args['orderby'] = 'date';
            $query_args['order'] = 'ASC';
        } else {
            $query_args['orderby'] = 'date';
            $query_args['order'] = 'DESC';
        }
    }

    $df_pg_paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
    if ( is_front_page() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
    }
    if ( $__et_blog_module_paged > 1 ) {
        $df_pg_paged            = $__et_blog_module_paged;
        $paged                  = $__et_blog_module_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged']    = $__et_blog_module_paged;
    }
    if ( ! is_search() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged'] = $df_pg_paged;
    }
    $query_args['paged'] = $df_pg_paged;

    if ( '' !== $offset_number && ! empty( $offset_number ) ) {
        /**
         * Offset + pagination don't play well. Manual offset calculation required
         *
         * @see: https://codex.wordpress.org/Making_Custom_Queries_using_Offset_and_Pagination
         */
        if ( $paged > 1 ) {
            $query_args['offset'] = ( ( $df_pg_paged - 1 ) * intval( $posts_number ) ) + intval( $offset_number );
        } else {
            $query_args['offset'] = intval( $offset_number );
        }
    }
    
    ob_start();
    query_posts( $query_args ); // phpcs:ignore WordPress.WP.DiscouragedFunctions

    echo '<div class="df-cpts-wrap layout-'.esc_attr($layout).'">';
    if ( have_posts() ) {
        while ( have_posts() ) {
            the_post();

            $equal_height_class = $equal_height === 'on' ? ' df-equal-height' : '';
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class( "df-cpt-item v2{$equal_height_class}" ) ?>>
                <div class="df-cpt-outer-wrap df-hover-trigger" <?php echo $use_background_scale !== 'on' ? et_core_esc_previously(df_cpt_image_as_background($use_image_as_background)): '';?>>
                    <?php 
                        // render markup to achive the scale effect.
                        if($use_image_as_background === 'on' && $use_background_scale === 'on') {
                            echo '<div class="df-cpt-bg-on-hover"><div ' . et_core_esc_previously(df_cpt_image_as_background($use_image_as_background)) .'></div></div>';
                        }
                        if(!empty($cpt_item_outer)) {
                            foreach( $cpt_item_outer as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        }
                    ?>
                    <div class="df-cpt-inner-wrap">
                        <?php 
                            foreach( $cpt_item_inner as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        ?>
                    </div>
                </div>
            </article>
            <?php
        } // endwhile
    }
    echo '</div>';

    // ajax navigation
    if ( 'on' === $show_pagination ) {
        if ( function_exists( 'wp_pagenavi' ) ) {
            wp_pagenavi();
        } else {
            add_filter( 'get_pagenum_link', array( 'DIFL_CptGrid', 'filter_pagination_url' ) );
            if ($use_number_pagination !== 'on') {
                cpt_render_pagination($older_text, $newer_text, $use_icon_only_at_pagination, true);
            } else {
                cpt_render_number_pagination($older_text, $newer_text, $use_icon_only_at_pagination, true);
            }
            remove_filter( 'get_pagenum_link', array( 'DIFL_CptGrid', 'filter_pagination_url' ) );
        }
    }

    wp_reset_query(); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    $posts = ob_get_contents();
    ob_end_clean();

    if(empty($cpt_items)) {
        $posts = '<h2 style="background:#eee; padding: 10px 20px;">Please <strong>Add New Item</strong> to continue.</h2>';
    }

    wp_send_json_success($posts);
}

function df_display_cpt_grid_load_actions( $actions ) {
	$actions[] = 'df_cpt_grid';

	return $actions;
}
add_filter( 'et_builder_load_actions', 'df_display_cpt_grid_load_actions' );

/**
 * CptFilter: Render Posts for CptFilter Module on VB
 * 
 */

add_action('wp_ajax_df_cpt_filter', 'df_cpt_filter');
function df_cpt_filter() {
    global $paged, $post, $wp_query, $wp_filter, $__et_blog_module_paged;

    // create the display gallery code
    $data = json_decode(file_get_contents('php://input'), true);
    if (! wp_verify_nonce( $data['et_admin_load_nonce'], 'et_admin_load_nonce' )) {
        wp_die();
    }

    $cpt_items = isset($data['cptItems']) ? $data['cptItems'] : array();
    
    $post_type = isset($data['post_type']) ? $data['post_type'] : ' project';
    $posts_number = isset($data['posts_number']) ? intval($data['posts_number']) : 10;
    $post_display = isset($data['post_display']) ? $data['post_display'] : 'recent';
    $orderby = isset($data['orderby']) ? $data['orderby'] : '1';
    $selected_taxonomy = isset($data['selected_taxonomy']) ? $data['selected_taxonomy'] : '';
    $selected_terms = isset($data['selected_terms']) ? $data['selected_terms'] : '';
    $offset_number = isset($data['offset_number']) ? $data['offset_number']: '0';
    $all_items = isset($data['all_items']) ? $data['all_items'] : 'off';
    $all_items_text = isset($data['all_items_text']) ? $data['all_items_text'] : 'All';
    $selected_texonomy_list = isset($data['selected_texonomy_list']) ? $data['selected_texonomy_list'] : '';
  
    $query_args = array(
        'posts_per_page' => $posts_number,
        'post_status'    => array( 'publish' ),
        'post_type'      => $post_type,
    );
    // orderby
    if( isset($data['orderby']) && $data['orderby'] === '3' ) {
        $query_args[ 'orderby' ] = 'rand';
    } elseif ( isset($data['orderby']) && $data['orderby'] === '2' ) {
        $query_args[ 'order' ] = 'ASC';
    }
    //by Multiple texonomy filter
    $multiple_cat = array();
    if($post_display === 'multiple_filter'){

        $selected_multi = explode("|", $selected_texonomy_list);
        $taxonomies = get_object_taxonomies( $post_type);
       
        $list_multi_key = array_values($taxonomies);
    
        for($i =0; $i<count($selected_multi); $i++){
            if($selected_multi[$i] === 'on'){
                array_push( $multiple_cat , $list_multi_key[$i] );
            }
        }
        if(empty($multiple_cat)){
            wp_send_json_success('<h2 style="background:#eee; padding: 10px 20px;">Please select any <strong>Taxonomy</strong>.</h2>');
            return;
        }
        $terms_query   = [];
        foreach($multiple_cat as $cat){

            $terms = get_terms( array(
                'taxonomy' => $cat,
                'hide_empty' => true,
            ) );
       
            $permittedValues = array_values($terms);
          
            $all_terms = $str = implode (", ", array_column($permittedValues, 'term_id'));
            $terms_query[] = [
                'taxonomy' => $cat,
                'field'    => 'term_id',
                'terms'    => $all_terms,
            ];

        }   
        $multi_filter_type = isset($data['multi_filter_type']) ? sanitize_text_field($data['multi_filter_type']) : 'AND';
        if (!empty($terms_query)) {
            
            $query_args['tax_query']             = $terms_query;
            $query_args['tax_query']['relation'] = 'OR';//$multi_filter_type;
        }
    
    }
    // by taxonomy
    else if('' !== $selected_terms) {
        $selected_terms_array = explode(',', $selected_terms);
        $initial_term_id = $selected_terms_array[0];
        if($all_items != 'on') {
            $query_args['tax_query'] = array( //phpcs:ignore WordPress.DB.SlowDBQuery
                'relation' => 'AND',
                array(
                    'taxonomy'  => $selected_taxonomy,
                    'field'     => 'term_id',
                    'terms'     => $initial_term_id
                )
            );
        }
        // if the all items is on
        if($all_items == 'on') {
            $query_args['tax_query'] = array( //phpcs:ignore WordPress.DB.SlowDBQuery
                'relation' => 'AND',
                array(
                    'taxonomy'  => $selected_taxonomy,
                    'field'     => 'term_id',
                    'terms'     => $selected_terms_array
                )
            );
        }
    } else {
        wp_send_json_success('<h2 style="background:#eee; padding: 10px 20px;">Please select a <strong>Post Type</strong>, <strong>Taxonomy</strong> and <strong>Terms</strong>.</h2>');
        return;
    }
    
    $df_pg_paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
    if ( is_front_page() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
    }
    if ( $__et_blog_module_paged > 1 ) {
        $df_pg_paged            = $__et_blog_module_paged;
        $paged                  = $__et_blog_module_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged']    = $__et_blog_module_paged;
    }
    if ( ! is_search() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged'] = $df_pg_paged;
    }
    $query_args['paged'] = $df_pg_paged;

    if ( '' !== $offset_number && ! empty( $offset_number ) ) {
        /**
         * Offset + pagination don't play well. Manual offset calculation required
         *
         * @see: https://codex.wordpress.org/Making_Custom_Queries_using_Offset_and_Pagination
         */
        if ( $paged > 1 ) {
            $query_args['offset'] = ( ( $df_pg_paged - 1 ) * intval( $posts_number ) ) + intval( $offset_number );
        } else {
            $query_args['offset'] = intval( $offset_number );
        }
    }

    $cpt_grid_options = array(
        'layout' => isset($data['layout']) ? $data['layout'] : 'grid',
        'cpt_item_inner' => isset($cpt_items['inner']) ? $cpt_items['inner'] : array(),
        'cpt_item_outer' => isset($cpt_items['outer']) ? $cpt_items['outer'] : array(),
        'equal_height' => isset($data['equal_height']) ? $data['equal_height'] : 'off',
        'use_image_as_background' => isset($data['use_image_as_background']) ? $data['use_image_as_background'] : 'off',
        'use_background_scale' => isset($data['use_background_scale']) ? $data['use_background_scale'] : 'off',
        'load_more' => isset($data['load_more']) ? $data['load_more'] : 'off',
        'use_load_more_icon' => isset($data['use_load_more_icon']) ? $data['use_load_more_icon'] : '',
        'load_more_font_icon' => isset($data['load_more_font_icon']) ? $data['load_more_font_icon'] : '',
        'load_more_icon_pos' => isset($data['load_more_icon_pos']) ? $data['load_more_icon_pos'] : '',
        'use_load_more_text' => isset($data['use_load_more_text']) ? $data['use_load_more_text'] : ''
    );
    
    ob_start();
    query_posts( $query_args ); // phpcs:ignore WordPress.WP.DiscouragedFunctions

    // render Cpt Filter navigation
    if($post_display !== 'multiple_filter') {
        echo et_core_esc_previously(render_cpt_filter_nav (
            $post_type, 
            $selected_taxonomy, 
            $selected_terms,
            $all_items,
            $all_items_text
        ));
    }else{
        echo et_core_esc_previously (generate_taxonomy_dropdown($multiple_cat , $data));
    }
    
    echo '<div class="df-cpts-wrap layout-'.esc_attr($cpt_grid_options['layout']).'">';
    echo '<div class="df-cpts-inner-wrap">';
    if ( have_posts() ) {
        while ( have_posts() ) {
            the_post();

            $equal_height_class = $cpt_grid_options['equal_height'] === 'on' ? ' df-equal-height' : '';
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class( "df-cpt-item v2{$equal_height_class}" ) ?>>
                <div class="df-cpt-outer-wrap df-hover-trigger" 
                    <?php echo $cpt_grid_options['use_background_scale'] !== 'on' ? et_core_esc_previously(df_cpt_image_as_background($cpt_grid_options['use_image_as_background'])) : '';?>>
                    <?php 
                        // render markup to achive the scale effect.
                        if($cpt_grid_options['use_image_as_background'] === 'on' && $cpt_grid_options['use_background_scale'] === 'on') {
                            echo '<div class="df-cpt-bg-on-hover"><div ' . et_core_esc_previously(df_cpt_image_as_background($cpt_grid_options['use_image_as_background'])) .'></div></div>';
                        }
                        if(!empty($cpt_grid_options['cpt_item_outer'])) {
                            foreach( $cpt_grid_options['cpt_item_outer'] as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        }
                    ?>
                    <div class="df-cpt-inner-wrap">
                        <?php
                            foreach( $cpt_grid_options['cpt_item_inner'] as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        ?>
                    </div>
                </div>
            </article>
            <?php
        } // endwhile
    }
    echo '</div>';

    // loading load more pagination
    if($cpt_grid_options['load_more'] == 'on') {
        if (  $wp_query->max_num_pages > 1 ) {
            df_cpt_filter_load_more_btn(
                'all', 
                $wp_query->max_num_pages,
                $cpt_grid_options['use_load_more_icon'],
                $cpt_grid_options['load_more_font_icon'],
                $cpt_grid_options['load_more_icon_pos'],
                $cpt_grid_options['use_load_more_text']
            );
        }
    }
    echo '</div>';

    wp_reset_query(); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    $posts = ob_get_contents();
    ob_end_clean();

    if(empty($cpt_items)) {
        $posts = '<h2 style="background:#eee; padding: 10px 20px;">Please <strong>Add New Item</strong> to continue.</h2>';
    }

    wp_send_json_success($posts);
}

/**
 * CPTFilter: Process Divi builder shortcode on ajax call
 * Builder, Filter, Loadmore
 *
 */
function df_display_cpt_filter_load_actions( $actions ) {
    $actions[] = 'df_cpt_filter_data';
    $actions[] = 'df_cpt_filter';
    return $actions;
}
add_filter( 'et_builder_load_actions', 'df_display_cpt_filter_load_actions' );

/**
 * CPT Filter: process grid data
 * 
 * @return String HTML
 */
function df_process_filter_grid_data($cpt_grid_options = array(), $term_id = ''){
    global $wp_query;
    $custom_post_type = '';
    ob_start();
    echo '<div class="df-cpts-inner-wrap">';
   
    if ( have_posts() ) {
        while ( have_posts() ) {
            the_post();
            $width = 'on' === 1080;
            // $width = 'on' === $fullwidth ? 1080 : 400;
            $width = (int) apply_filters( 'et_pb_blog_image_width', $width );

            $height    = 'on' === 675;
            $height    = (int) apply_filters( 'et_pb_blog_image_height', $height );
            $equal_height_class = $cpt_grid_options['equal_height'] === 'on' ? ' df-equal-height' : '';

            $outer_content = '';
            $inner_content = '';

            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class( "df-cpt-item v2{$equal_height_class}" ) ?> data-height='auto'>
                <div class="df-cpt-outer-wrap df-hover-trigger" 
                    <?php echo $cpt_grid_options['use_background_scale'] !== 'on' ? et_core_esc_previously(df_cpt_image_as_background($cpt_grid_options['use_image_as_background'])) : '';?>>
                    <?php
                        // render markup to achive the scale effect.
                        if($cpt_grid_options['use_image_as_background'] === 'on' && $cpt_grid_options['use_background_scale'] === 'on') {
                            echo '<div class="df-cpt-bg-on-hover"><div ' . et_core_esc_previously(df_cpt_image_as_background($cpt_grid_options['use_image_as_background'])) .'></div></div>';
                        }
                        if( !empty($cpt_grid_options['cpt_item_outer']) ) {
                            foreach( $cpt_grid_options['cpt_item_outer'] as $post_item ) {

                                if( !isset($post_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $post_item['type'];

                                call_user_func($callback, $post_item);

                            } // end of foreach
                        }
                    ?>
                    <div class="df-cpt-inner-wrap">
                        <?php
                            if( !empty( $cpt_grid_options['cpt_item_inner'] ) ) {
                                foreach( $cpt_grid_options['cpt_item_inner'] as $post_item ) {
                                
                                    if( !isset($post_item['type'])) {
                                        continue;
                                    }
    
                                    $callback = 'df_cpt_' . $post_item['type'];
    
                                    call_user_func($callback, $post_item);
                                } 
                            }
                            // end of foreach
                        ?>
                    </div>
                </div>
            </article>
            <?php
        } // endwhile

      
    }
    else{
        echo '<h2 class="no-post"style="background-color:#eee; padding: 10px 20px; text-align:center">No data found.</h2>';
    }
    echo '</div>';

    if($cpt_grid_options['load_more'] == 'on') {
        // loading load more pagination
        if (  $wp_query->max_num_pages > 1) {
            df_cpt_filter_load_more_btn(
                $term_id, 
                $wp_query->max_num_pages,
                $cpt_grid_options['use_load_more_icon'],
                $cpt_grid_options['load_more_font_icon'],
                $cpt_grid_options['load_more_icon_pos'],
                $cpt_grid_options['use_load_more_text']
            );
        }
    }

    $posts = ob_get_contents();
    ob_end_clean();
    return $posts;
}

/**
 * CPT Filter: Rendering filtered data.
 * Fetch Request.
 * 
 */
add_action('wp_ajax_df_cpt_filter_data', 'df_cpt_filter_data');
add_action('wp_ajax_nopriv_df_cpt_filter_data', 'df_cpt_filter_data');

function df_cpt_filter_data() {
    global $post, $paged, $wp_query, $wp_the_query, $wp_filter, $__et_blog_module_paged;

    $main_query = $wp_the_query;

    if (isset($_POST['et_frontend_nonce']) && !wp_verify_nonce( sanitize_text_field($_POST['et_frontend_nonce']), 'et_frontend_nonce' ) ) {
        wp_die();
    }

    if(!function_exists('et_pb_post_format')) {
        require_once get_template_directory() . '/includes/builder/functions.php';
    } 
    if(!class_exists('Df_Acf_Fields')) {
        require_once( DIFL_MAIN_DIR . '/includes/classes/df-acf-fields.php' );
    }

    $post_type = isset($_POST['post_type']) ? sanitize_text_field($_POST['post_type']) : '';
    $post_display = isset($_POST['post_display']) ? sanitize_text_field($_POST['post_display']) : '';
    $posts_number = isset($_POST['posts_number']) ? sanitize_text_field($_POST['posts_number']) : '';
    $load_more = isset($_POST['load_more']) ? sanitize_text_field($_POST['load_more']) : 'off';
    $_request = isset($_POST['_request']) ? sanitize_text_field($_POST['_request']) : 'filter';
    $current_paged = isset($_POST['current_page']) ? sanitize_text_field($_POST['current_page']) : '';

    $term_id = isset($_POST['term_id']) ? sanitize_text_field($_POST['term_id']) : 'all';

    $taxonomy = isset($_POST['selected_tax']) ? sanitize_text_field($_POST['selected_tax']) : '';
    $query_args = array(
        'posts_per_page' => intval($posts_number),
        'post_status'    => array( 'publish' ),
        'perm'           => 'readable',
        'post_type'      => $post_type,
        'paged'          => $_request == 'filter' ? 1 : intval($current_paged) + 1
    );
    // order by
    if( isset($_POST['orderby']) && $_POST['orderby'] === '3' ) {
        $query_args[ 'orderby' ] = 'rand';
    } elseif ( isset($_POST['orderby']) && $_POST['orderby'] === '2' ) {
        $query_args[ 'order' ] = 'ASC';
    }
    if($post_display === 'multiple_filter'){
        
        $terms_query   = [];
        $multi_texonomies = json_decode(str_replace('\\', '', $taxonomy));  
     
        foreach($multi_texonomies as $multi_texonomy){
            //var_dump($multi_texonomy->term_id);
            if(!empty($multi_texonomy->term_id)){
                //$slugs = substr($multi_texonomy->term_id, 1, -1);
                 $terms_query[] = [
                    'taxonomy' => $multi_texonomy->texonomy_name,
                    'field'    => 'slug',
                    'terms'    => $multi_texonomy->term_id,
                    'operator' => 'IN',
                ];
            }
           
        }   
      
        $multi_filter_type = isset($_POST['multi_filter_type']) ? sanitize_text_field($_POST['multi_filter_type']) : 'AND';
        if (!empty($terms_query)) {
            $query_args['tax_query']             = $terms_query;
            $query_args['tax_query']['relation'] =  $multi_filter_type;
        }

       
    }else{
        if($term_id != 'all') {
            $query_args['tax_query'] = array( // phpcs:ignore WordPress.DB.SlowDBQuery
                'relation' => 'OR',
                array(
                    'taxonomy'      => $taxonomy,
                    'field'         => 'term_id',
                    'terms'         => explode(',', $term_id)
                )
            );
        }
    }

    $cpt_grid_options = array(
        'layout' => isset($_POST['layout']) ? sanitize_text_field($_POST['layout']) : 'grid',
        'cpt_item_inner' => isset($_POST['cpt_item_inner']) ? json_decode(stripslashes(trim(sanitize_text_field($_POST["cpt_item_inner"]), '"')), true) : array(),
        'cpt_item_outer' => isset($_POST['cpt_item_outer']) ? json_decode(stripslashes(trim(sanitize_text_field($_POST["cpt_item_outer"]), '"')), true) : array(),
        'equal_height' => isset($_POST['equal_height']) ? sanitize_text_field($_POST['equal_height']) : '',
        'use_image_as_background' => isset($_POST['use_image_as_background']) ? sanitize_text_field($_POST['use_image_as_background']) : '',
        'use_background_scale' => isset($_POST['use_background_scale']) ? sanitize_text_field($_POST['use_background_scale']) : '',
        'load_more' => $load_more,
        'use_load_more_icon' => isset($_POST['use_load_more_icon']) ? sanitize_text_field($_POST['use_load_more_icon']) : '',
        'load_more_font_icon' => isset($_POST['load_more_font_icon']) ? sanitize_text_field($_POST['load_more_font_icon']) : '',
        'load_more_icon_pos' => isset($_POST['load_more_icon_pos']) ? sanitize_text_field($_POST['load_more_icon_pos']) : '',
        'use_load_more_text' => isset($_POST['use_load_more_text']) ? sanitize_text_field($_POST['use_load_more_text']) : ''
    );

    ob_start();
    query_posts( $query_args ); // phpcs:ignore WordPress.WP.DiscouragedFunctions

    echo et_core_esc_previously(df_process_filter_grid_data($cpt_grid_options, $term_id));

    $wp_the_query = $wp_query = $main_query; // phpcs:ignore WordPress.WP.GlobalVariablesOverride
    wp_reset_query(); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    $posts = ob_get_contents();
    ob_end_clean();

    wp_send_json_success($posts);
}

/**
 * CptFilter: Load more button renderer
 * 
 * @param String $term_id
 * @param INT $max_num_pages
 * @param String $use_icon
 * @param String $font_icon
 * @param Strign $position
 * @param String $text | load more text
 */
function df_cpt_filter_load_more_btn($term_id, $max_num_pages, $use_icon, $font_icon, $position = 'right', $text = 'Load More'){
    $icon = 'on' == $use_icon ? sprintf('<span class="et-pb-icon df-load-more-icon">%1$s</span>', 
        esc_attr(et_pb_process_font_icon($font_icon))) : '';
    $icon_right = ($position === 'right') ? $icon : '';
    $icon_left = ($position === 'left') ? $icon : '';
    echo sprintf('<div class="load-more-pagintaion-container" style="opacity:0;">
            <a class="df-cptfilter-load-more" href="#" data-term="%2$s" data-pages="%3$s" data-current="1">%5$s %1$s %4$s</a>
        </div>',
        esc_html($text),
        esc_attr($term_id),
        esc_attr($max_num_pages),
        et_core_esc_previously($icon_right),
        et_core_esc_previously($icon_left)
    );
}

/**
 * CptFilter: Rendering Multiple Texonomy filter for CptFilter
 * 
 * @param String | $post_type
 * @param String | $taxonomy
 * @param String | $terms
 * 
 * @return String | $html
 */
 function termlist_options($tex_name , $tex_label){
    $terms = get_terms($tex_name);
    $term_name_html = "<option value='all'> All  $tex_label </option>";
    foreach($terms as $term ){
        $term_id = $term->term_id;
        $name = $term->name;
        $term_name_html .= "<option value=$term_id> $name </option>";
    }
    return $term_name_html;
}
 function generate_taxonomy_dropdown($taxonomy_lists , $data){
    $html = "<ul class='multiple_taxonomy_filter'>";

    $heading_text = $data['use_multi_filter_label'] === 'on' && $data['enable_single_filter_label'] === 'on' && isset($data['single_label_text']) && $data['single_label_text'] !== '' ? 
                sprintf('<li><span class="multi_filter_label"> %1$s </span></li>' , esc_html__($data['single_label_text'], 'divi_flash') ) 
                : '';
    $html .=$heading_text;
    $index = 0;
    foreach($taxonomy_lists as $key =>$value){
        $index++;
        $taxonomy_details = get_taxonomy( $value );
        $prefix_label = $data['use_multi_filter_label'] === 'on' && isset($data['prefix_multi_filter_label']) && $data['prefix_multi_filter_label'] !== '' ? $data['prefix_multi_filter_label'] : '';
        $label_text = $data['enable_single_filter_label'] === 'on' && isset($data['single_label_text']) && $data['single_label_text'] !== '' ?  $data['single_label_text'] :  $prefix_label  ." ". $taxonomy_details->label;
        $term_options = termlist_options($value , $taxonomy_details->label);
        $multi_filter_label=$data['use_multi_filter_label'] === 'on' ? 
                            sprintf('<span class="multi_filter_label"> %1$s </span>' , esc_html__($label_text, 'divi_flash') )
                            : '';
        if($data['enable_single_filter_label'] === 'on'){
            $multi_filter_label = '';
        }
        $html .=sprintf('
                        <li> 
                        
                            %3$s 
                            <div class="multi-select-component">
                                <select  placeholder="All Terms" id="%1$s" name="%1$s" multiple data-multi-select-plugin>
                                    %2$s
                                </select>
                               
                                <div class="search-container"><input class="selected-input" autocomplete="off" tabindex="0" placeholder="All %4$s"><a href="#" class="dropdown-icon"></a></div>
                            </div>
                        </li>
                        
                        ',
                        $value, 
                        $term_options,
                        $multi_filter_label,
                        $taxonomy_details->label
                    );
    }
     
    $html .= "</ul>";

    return $html;
}

/**
 * CptFilter: Rendering navigation for CptFilter
 * 
 * @param String | $post_type
 * @param String | $taxonomy
 * @param String | $terms
 * 
 * @return String | $html
 */
function render_cpt_filter_nav($post_type, $taxonomy, $terms, $all_items = 'off', $all_items_text = 'All') {
    $terms_array = explode(',', $terms);
    $html = '';
    $index = 0;

    if(empty($terms)) {
        return;
    }

    $html .= '<ul class="df-cpt-filter-nav">';
    if($all_items == 'on') {
        $html .= sprintf('<li data-term="%2$s" class="df-cpt-filter-nav-item df-active">%1$s</li>', 
            esc_html($all_items_text),
            $terms
        );
    }
    foreach ( $terms_array as $term ) {
        $active_class = $index === 0 && $all_items != 'on' ? 'df-active' : '';
        $html .= sprintf('<li data-term="%1$s" class="df-cpt-filter-nav-item %3$s">%2$s</li>', 
            get_term(intval($term)) !==NULL ? esc_html(get_term(intval($term))->term_id) : '', 
            get_term(intval($term)) !==NULL ? esc_html(get_term(intval($term))->name) : '',
            $active_class
        );
        $index++;
    }
    $html .= '</ul>';

    return $html;
} 



/**
 * Render simple pagination for blog
 * 
 * @param String older entries text
 * 
 * @param String next entries text
 */
function cpt_render_pagination( $older, $newer, $use_icon_only_at_pagination, $builder = false ) {
    add_filter('next_posts_link_attributes', 'df_cpt_next_link_attributes');
    add_filter('previous_posts_link_attributes', 'df_cpt_prev_link_attributes');

    $older = $use_icon_only_at_pagination === 'on' ? '' : $older;
    $newer = $use_icon_only_at_pagination === 'on' ? '' : $newer;
    $class = $use_icon_only_at_pagination == 'on' ? 'only_icon' : '';

    echo '<div class="df-pagination pagination clearfix '.esc_attr($class).'">';
        if($builder === true) {
            echo '<a class="older page-numbers" href="#">'.esc_html__("{$older}",'divi_flash').'</a>';
            echo '<a class="newer page-numbers" href="#">'.esc_html__("{$newer}",'divi_flash').'</a>';
        } else {
            next_posts_link(esc_html__("{$older}",'divi_flash'));
            previous_posts_link(esc_html__("{$newer}", 'divi_flash'));
        }
    echo '</div>';

    remove_filter('next_posts_link_attributes', 'df_cpt_next_link_attributes');
    remove_filter('previous_posts_link_attributes', 'df_cpt_prev_link_attributes');
}
/**
 * Render numbered pagination
 * 
 * @param String older entries text
 * 
 * @param String next entries text
 */
function cpt_render_number_pagination( $older, $newer, $use_icon_only_at_pagination, $builder = false ) {
    global $wp_query;
    $older = $use_icon_only_at_pagination === 'on' ? '' : $older;
    $newer = $use_icon_only_at_pagination === 'on' ? '' : $newer;
    $class = $use_icon_only_at_pagination == 'on' ? 'only_icon' : '';
    $big = 9999999; // need an unlikely integer
    echo '<div class="df-pagination pagination clearfix '.esc_attr($class).'">';
        if($builder === true) {
            echo '<a class="prev page-numbers" href="#">'.esc_html__("{$older}",'divi_flash').'</a>';
        }
        echo paginate_links( array(
            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var('paged') ),
            'total' => $wp_query->max_num_pages,
            'prev_text' => esc_html__("{$older}",'divi_flash'),
            'next_text' => esc_html__("{$newer}", 'divi_flash')
        ));
    echo '</div>';
}
/**
 * add class attributes to
 * previous and next posts links
 * 
 */
function df_cpt_next_link_attributes() {
    return 'class="older page-numbers"';
}
function df_cpt_prev_link_attributes() {
    return 'class="newer page-numbers"';
}

/**
 * Render Posts for CPTCarousel Module on VB
 * 
 */
add_action('wp_ajax_df_cpt_carousel', 'df_cpt_carousel');
function df_cpt_carousel() {
    global $paged, $post, $wp_query, $wp_filter, $__et_blog_module_paged;

    // create the display gallery code
    $data = json_decode(file_get_contents('php://input'), true);
    if (! wp_verify_nonce( $data['et_admin_load_nonce'], 'et_admin_load_nonce' )) {
        wp_die();
    }
    if($data['post_type'] === 'select'){
        wp_send_json_success('<h2 style="background:#eee; padding: 10px 20px;">Please select a <strong>Custom Post Type</strong>.</h2>');
        return;
    }
    $post_type = isset($data['post_type']) ? $data['post_type'] : 'project';
    
    $cpt_items = isset($data['cptItems']) ? $data['cptItems'] : array();

    $posts_number = isset($data['posts_number']) ? intval($data['posts_number']) : 10;
    $post_display = isset($data['post_display']) ? $data['post_display'] : 'recent';
    $orderby = isset($data['orderby']) ? $data['orderby'] : '1';
    $selected_taxonomy = isset($data['selected_taxonomy']) ? $data['selected_taxonomy'] : '';
    $selected_terms = isset($data['selected_terms']) ? $data['selected_terms'] : '';
    $offset_number = isset($data['offset_number']) ? $data['offset_number']: '0';
    $use_current_loop = $data['use_current_loop'];
    $post_type_arch = $data['post_type_arch'];
    $post_type = $use_current_loop === 'on' ? $post_type_arch : $post_type;
    $query_args = array(
        'posts_per_page' => $posts_number,
        'post_status'    => array( 'publish' ),
        'perm'           => 'readable',
        'post_type'      => $post_type,
    );
    // orderby
    if( isset($data['orderby']) && $data['orderby'] === '3' ) {
        $query_args[ 'orderby' ] = 'rand';
    } elseif ( isset($data['orderby']) && $data['orderby'] === '2' ) {
        $query_args[ 'order' ] = 'ASC';
    }
    
    // by taxonomy
    if( 'by_tax' === $post_display && '' !== $selected_terms ) {
        $selected_terms_array = explode(',', $selected_terms);
        $initial_term_id = $selected_terms_array[0];
        $query_args['tax_query'] = array( //phpcs:ignore WordPress.DB.SlowDBQuery
            'relation' => 'AND',
            array(
                'taxonomy'  => $selected_taxonomy,
                'field'     => 'term_id',
                'terms'     => $initial_term_id
            )
        );
    }

    $df_pg_paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
    if ( is_front_page() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
    }
    if ( $__et_blog_module_paged > 1 ) {
        $df_pg_paged            = $__et_blog_module_paged;
        $paged                  = $__et_blog_module_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged']    = $__et_blog_module_paged;
    }
    if ( ! is_search() ) {
        $paged = $df_pg_paged; //phpcs:ignore WordPress.WP.GlobalVariablesOverride
        $query_args['paged'] = $df_pg_paged;
    }
    $query_args['paged'] = $df_pg_paged;

    if ( 'off' === $use_current_loop ) {
        query_posts( $query_args ); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    } elseif ( is_singular() ) {
        // Force an empty result set in order to avoid loops over the current post.
        query_posts( array( 'post__in' => array( 0 ) ) ); // phpcs:ignore WordPress.WP.DiscouragedFunctions
        // $show_no_results_template = false;
    } else {
        // Only allow certain args when `Posts For Current Page` is set.
        $original = $wp_query->query_vars;
        $custom   = array_intersect_key( $query_args, array_flip( array( 'posts_per_page', 'offset', 'paged' ) ) );

        // Trick WP into reporting this query as the main query so third party filters
        // that check for is_main_query() are applied.
        $wp_the_query = $wp_query = new WP_Query( array_merge( $original, $custom ) ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride
    }
    

    if ( '' !== $offset_number && ! empty( $offset_number ) ) {
        /**
         * Offset + pagination don't play well. Manual offset calculation required
         *
         * @see: https://codex.wordpress.org/Making_Custom_Queries_using_Offset_and_Pagination
         */
        if ( $paged > 1 ) {
            $query_args['offset'] = ( ( $df_pg_paged - 1 ) * intval( $posts_number ) ) + intval( $offset_number );
        } else {
            $query_args['offset'] = intval( $offset_number );
        }
    }

    $cpt_carousel_options = array(
        'cpt_item_inner' => isset($cpt_items['inner']) ? $cpt_items['inner'] : array(),
        'cpt_item_outer' => isset($cpt_items['outer']) ? $cpt_items['outer'] : array(),
        'equal_height' => isset($data['equal_height']) ? $data['equal_height'] : 'off',
        'use_image_as_background' => isset($data['use_image_as_background']) ? $data['use_image_as_background'] : 'off',
        'use_background_scale' => isset($data['use_background_scale']) ? $data['use_background_scale'] : 'off',
    );
    
    ob_start();
    query_posts( $query_args ); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    
    
    //echo '<div class="df-cpts-inner-wrap">';
    if ( have_posts() ) {
        echo '<div class="df-cpts-wrap swiper-wrapper">';
        while ( have_posts() ) {
            the_post();

            $equal_height_class = $cpt_carousel_options['equal_height'] === 'on' ? ' df-equal-height' : '';
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class( "df-cpt-item swiper-slide v2{$equal_height_class}" ) ?>>
                <div class="df-cpt-outer-wrap df-hover-trigger" 
                    <?php echo $cpt_carousel_options['use_background_scale'] !== 'on' ? et_core_esc_previously(df_cpt_image_as_background($cpt_carousel_options['use_image_as_background'])) : '';?>>
                    <?php 
                        // render markup to achive the scale effect.
                        if($cpt_carousel_options['use_image_as_background'] === 'on' && $cpt_carousel_options['use_background_scale'] === 'on') {
                            echo '<div class="df-cpt-bg-on-hover"><div ' . et_core_esc_previously(df_cpt_image_as_background($cpt_carousel_options['use_image_as_background'])) .'></div></div>';
                        }
                        if(!empty($cpt_carousel_options['cpt_item_outer'])) {
                            foreach( $cpt_carousel_options['cpt_item_outer'] as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        }
                    ?>
                    <div class="df-cpt-inner-wrap">
                        <?php
                            foreach( $cpt_carousel_options['cpt_item_inner'] as $cpt_item ) {

                                if( !isset($cpt_item['type'])) {
                                    continue;
                                }

                                $callback = 'df_cpt_' . $cpt_item['type'];

                                call_user_func($callback, $cpt_item, true);

                            } // end of foreach
                        ?>
                    </div>
                </div>
            </article>
            <?php
        } // endwhile
        echo '</div>';
    }else{
        echo "<h3 style='text-align:center;background:#eee; padding: 10px 20px;'>No Post Found.</h3>";
    }
   
    wp_reset_query(); // phpcs:ignore WordPress.WP.DiscouragedFunctions
    $posts = ob_get_contents();
    ob_end_clean();

    if(empty($cpt_items)) {
        $posts = '<h2 style="background:#eee; padding: 10px 20px;">Please <strong>Add New Post Element.</strong></h2>';
    }

    wp_send_json_success($posts);
}

function df_display_cpt_carousel_load_actions( $actions ) {
	$actions[] = 'df_cpt_carousel';

	return $actions;
}
add_filter( 'et_builder_load_actions', 'df_display_cpt_carousel_load_actions' );

/**
 * Render icon/image for times
 * 
 * @param Array $settings
 * @return String html
 */
function df_cpt_render_icon_image($settings) {
    if(('on' != $settings['use_icon']) && !isset($settings['image_icon'])) {
        return;
    }

    $image_alt_text =  isset($settings['image_icon']) ? df_image_alt_by_url($settings['image_icon']) : '';
    
    $image_icon = isset($settings['image_icon']) && $settings['image_icon'] !== '' ? sprintf('<img class="df-icon-image" alt="%2$s" src="%1$s" />', esc_attr($settings['image_icon']) , esc_attr($image_alt_text)) : '';
    return $settings['use_icon'] === 'on' ? 
        sprintf('<span class="et-pb-icon">%1$s</span>', $settings['font_icon']) : $image_icon;
}

/**
 * Filter the main query paged arg to avoid pagination clashes with the Post modules pagination.
 *
 * @param WP_Query $query Query object.
 *
 * @return void
 */
function df_filter_main_query_paged_for_cpt_module( $query ) {
	global $__et_blog_module_paged;

	// phpcs:ignore WordPress.Security.NonceVerification -- This function does not change any state, and is therefore not susceptible to CSRF.
	if ( isset( $_GET['df_cpt'] ) && $query->is_main_query() ) {
		$__et_blog_module_paged = $query->get( 'paged' );
		$query->set( 'paged', 0 );
	}
}
add_filter( 'pre_get_posts', 'df_filter_main_query_paged_for_cpt_module' );

function searcharray($value, $key, $array) {
    foreach ($array as $k => $val) {
        if ($val[$key] == $value) {
            return $k;
        }
    }
    return null;
 }