const df_frames = {
    'desktop' : "data:image/svg+xml;base64,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",
    'phone'   : "data:image/svg+xml;base64,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",
    'tablet'  : "data:image/svg+xml;base64,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",
    'macbook' : "data:image/svg+xml;base64,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",
    'macbookpro': "data:image/svg+xml;base64,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",
    'ipad'    : "data:image/svg+xml;base64,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",
    'chrome'  : "data:image/svg+xml;base64,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",
    'chrome_dark' : "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTQ0MCIgaGVpZ2h0PSI4OTAiIHZpZXdCb3g9IjAgMCAxNDQwIDg5MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CjxyZWN0IHdpZHRoPSIxNDQwIiBoZWlnaHQ9Ijg5MCIgZmlsbD0idXJsKCNwYXR0ZXJuMCkiLz4KPGRlZnM+CjxwYXR0ZXJuIGlkPSJwYXR0ZXJuMCIgcGF0dGVybkNvbnRlbnRVbml0cz0ib2JqZWN0Qm91bmRpbmdCb3giIHdpZHRoPSIxIiBoZWlnaHQ9IjEiPgo8dXNlIHhsaW5rOmhyZWY9IiNpbWFnZTBfMjI4XzQ0IiB0cmFuc2Zvcm09InNjYWxlKDAuMDAwNjk0NDQ0IDAuMDAxMTIzNikiLz4KPC9wYXR0ZXJuPgo8aW1hZ2UgaWQ9ImltYWdlMF8yMjhfNDQiIHdpZHRoPSIxNDQwIiBoZWlnaHQ9Ijg5MCIgeGxpbms6aHJlZj0iZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUJhQUFBQU42Q0FNQUFBQlBDeDZKQUFBQWlsQk1WRVVBQUFBU0VoSWdJQ0ExTlRXR2lvdFRVMVA4L1B4OWZuOHlNakx5OC9OR1JrY29LQ2c2T2pvdExTMkNnNE1oSVNGZFgyQWtKQ1F2THk5QlFVRVZGUlZQVDA5TFMwdWtwS1NVbEpSdmNISEt5OHZYMk5pV2w1ZGZZMmMzTnpjYkd4dnY3Kyt4c3JMbzZ1emYzOStJaVlrek16TjNlbnErdjcrTWpJeG9hMnZrNU9Sb2FXbkt5c3BVVkZURHRXV0JBQUFBQVhSU1RsTUFRT2JZWmdBQUVocEpSRUZVZU5yczNPMXVtekFZUU9FNmJ4MWF4MGsvQUV0UlZhSXR5djNmNGt6S2JMWkMyQStDakhjZUliQzRnQ05rWXo4OEFnQ1M5UENvQUFBSkl0QUFrQ2dDRFFDSkl0QUFrQ2dDRFFDSkl0QUFrQ2dDRFFDSkl0QUFrQ2dDRFFDSitqdlExZHVUWkdhL3F4UUFMTWdVZ1ZFVFBnNnFjL2k0SGVqTlJUSjBlVkVBc0p6aVIvSEZEOVNFdy9NaERHNEcra1V5dFZFQU1PQlk5TWJIMlFKZDlFZlRoWTZQOFVCWFdYNC90eTdNY2dBWWN2d1pXK3FIU3djNkZycTkzUXowVHJMMXBnQ2dMMlk1RHBZT2RDeTB2eVlXQ2ZlU3JYY0ZBQ09GRG8rbEF4MEw3ZnM4RVdqSm1BS0FzVUwvWTUrZkF3Sk5vQUVzd2NmNXE4OUpUM0ZJanpXMTFzNVl5WVFDZ05GQ2QzMU9lWkZRZ3Nib2pwRThLQUFZVXh6VlZjcS8yVW5nZE9Ba0MrcWI4MWtCd0I4UzNxZ2l2elZ0b1BQNmhsYmZiTGNLQVBwUzN1b3RIZXVhV210WGRpU3dydFp6Y1ZidTZkV0laMTdsaWtBRFdKL0JRQnRkK3NzYVk2M3hRcUZ0cldkVVc3a2o4Mm02VzR0QUExaWZ3VUE3WFRmR2FzKzZ0cVR4L2F5YzNFVXNkT3d6Z1Fhd1BvT0J2azQ4RysyWlVudmgvYnhxdVN2ejZmc2NxTDd6Tm1DbEVFQ3F4Z0t0N1VDZ2F6MHZHVUtnQVdBbzBESEV6bXF2Y2UyUUtRNEFXTWowSXFGWE5zYllVbnVoY3MyOGk0U05ER0dSRUFER0EyMTF5NVdsMU5xTElXM2NmSGwydzMzbU56c0F1QkZvTWZxcUxMVm1vd29BTEcxNkoyRnRhODFXYndCWTNQUmhTYVhKNXZ1Wnc1SUFyTTlJb050RUc2dHJqaHNGZ0VWd1lEOEFyQWVCQm9CRUVXZ0FTRlEvMEpWa3JGSUFzQzc5UUo4a1l4c0ZBT3ZTRC9ST01yWlhBTEF1UHREL3hReUh5RWtCd0tyRVFGZFBrclYzWnFFQnJFc0k5Q256UGxQb1gremQzWEtpTUJpQTRTWHBVRFJrRUtxRC9IVFVXYXl1Mjk3LzdXMnd0RlFMcHFVekF1NzdIQlFQZS9STzVpTUpBTWJtTmRCem9lVi9RSzFvTklEeE1JR1dBSUFCSXRBQU1GQUVHZ0FHaWtBRHdFRDFHdWhJaFlFQWdPRUxRaFZKcTlzSnRDYk9BTVlrME5MaVZnTHRoUUlBeGlYdzVFVTNFbWlXendCR0tJamtKYmNSNkVnQXdCaHAyY2syTEEvS3pWZHErSUgyV0Q4REdLZHVVdzQxZHlwek5mUkEwMmNBWXhWMmFaN3pRZmpUUVB0UE0ya3hlL0xsQll2ODRMclpaaUhsWHA3VDRrMmdJcy9UREtRQkROZHNhaHR5dUNma0o2RnpJcENObHBPbExkQlZuKy9zZ2I2N1ZPajllcjNaMytlSDlUNTMyeGZRb2ZlS2tRZUFua3lxWithTEZ0bEduQWkrRzJqbEhEMHNsOUdscjZOTUpwTXZCVHF4OU5sYTZMMmJMV1RwZnUyNnJXOElsV2RvSFhsS0FFQVA2a0NudTVaQ0ozSHhJazVFOGt5ZHVjWkF6NTFTWkdxNDlwM1NmUHVERmZTZnFzL1dRaWV5MmNJOVBNaWp2T0cvVmUremRzOVRnZm5CbG1nQVBhZ0RuV3pTM0c4cGRPYnJuVGloTElGdVhrRG5yckcwaktHdGdhNzdiQy8wWDlsbzR5N2swYjdwdjMzcnNmWllPZ1BvVFIzb1BOZm03elFUNS9RMGlXTWg0bnoyb3NXNzhIdUJYbjBPOUtwcm9PMTl0aGM2MjMxbEQwZmtSY0pRUjZRYVFCOU1vSk5DK0M5VGtSZmlUSnJGUmFLRjhHZkZKazJiaDlEMlFNK3JFWFE1NG9pY28zbkhFWWZwOHdmM3NzSFRYYTI1MEc0dUx4QVZ6OVBIeHlzQkFOZG5BcjE3U2ZOaVZ4VGkzRFQxUmNWUHArTGQ5d0x0VktMbDhzR3AyRjhTMmdQZFBHUytKOUFBYm9VSjlDSFc1bW42M0Zib3VzL2RBeDB0WStOdEgwZkxDdm9xSTQ3RDg5ZEdIRjc1VXhsbHF3SGcra3lnTTJFa29vbWZhbUhvbmVuemowWWMwZG90VmZzNFZyMitKRncveUhaaHZjdE9pU01DRGFBbms2YWZ0YlIrL09nbDRjNnQ3QzRGK2lyYjdHYnJaMW03dU0ydWZDcU9xZ0RvaVQzUTJqY1AzWDJiWGVnWXY5M0tiOGRRTFNPT2F4MVVPU3lrOGZkd0x6K0pQaDRrakxUMlBQYmJBZWlCUGREVGpTN1NMUGJqYWZlREt0djVlYURuYlNjSnIzWFUyM1dmOC9qWlhTZXRNdzVEZWErNHZSOUFUeVlmaUU4ZTB6UVJJdGxsaVhnWGRqbnFYY1NWWmJXQTdyNkNOb1YrbEJhUGxzdVNObG5aNkFkcFhMZ3NxVncvUjRyNUJvQkJtaFZhbEpMWlR5NUxDcHdUNGJDdkcyWEJER0Nzd2k3TmN6NElCbjRmOUpZbE00QnhDcmEzZm1HL1pGTWRnSEdLWkRkcXRUSjFYb1hid1gveWlvL0dBaGlsUU10T1J2WFJXQ20zektFQmpJMXQvWHNyZ1paU2syZ0FZeEpxYVhFN2daWXlVaUdURGdCakVJUXFrbGEzRkdnQUFJRUdnTkVoMEFBd1VDYlFBSUJCK25YM0N3QXdRQVFhQUFhS1FBUEFRQkZvQUJnb0FnM2dIenQxTEFBQUFBQXd5Tjk2R2pzS0lxWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlDcDJLbGpBUUFBQUlCQi90YlQyRkVRQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNEltZHVwWUFBQUFBR0NRdi9VMGRoUkV3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURjUk9IUXNBQUFBQURQSzNuc2FPZ29ncFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnS25icVdBQUFBQUJna0wvMU5IWVVSSUlHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dpWjA2RmdBQUFBQVk1Rzg5alIwRkVUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFPeFU4Y0NBQUFBQUlQOHJhZXhveUJpU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtSXFkT2hZQUFBQUFHT1J2UFkwZEJaR2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFHS25qZ1VBQUFBQUJ2bGJUMk5IUVFSTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEJBN05TeEFBQUFBTUFnZit0cDdDaUltQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWmlwNDRGQUFBQUFBYjVXMDlqUjBFa2FJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1pyWXFXTUJBQUFBZ0VIKzF0UFlVUkFCVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTBFRHQxTEFBQUFBQXd5Tjk2R2pzS0lxWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlDcDJLbGpBUUFBQUlCQi90YlQyRkVRQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNEltZHVwWUFBQUFBR0NRdi9VMGRoUkV3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURjUk9IUXNBQUFBQURQSzNuc2FPZ29ncFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnS25icVdBQUFBQUJna0wvMU5IWVVSSUlHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dpWjA2RmdBQUFBQVk1Rzg5alIwRkVUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFPeFU4Y0NBQUFBQUlQOHJhZXhveUJpU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtR3JBQW5vVWpJSlJNQXBHd2FBRUFCSHltWTdYcEdFd0FBQUFBRWxGVGtTdVFtQ0MiLz4KPC9kZWZzPgo8L3N2Zz4K",
    'firefox' : "data:image/svg+xml;base64,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",
    'firefox_dark' : "data:image/svg+xml;base64,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",
    'edge'    : "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTQ0MCIgaGVpZ2h0PSI4OTAiIHZpZXdCb3g9IjAgMCAxNDQwIDg5MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CjxyZWN0IHdpZHRoPSIxNDQwIiBoZWlnaHQ9Ijg5MCIgZmlsbD0idXJsKCNwYXR0ZXJuMCkiLz4KPGRlZnM+CjxwYXR0ZXJuIGlkPSJwYXR0ZXJuMCIgcGF0dGVybkNvbnRlbnRVbml0cz0ib2JqZWN0Qm91bmRpbmdCb3giIHdpZHRoPSIxIiBoZWlnaHQ9IjEiPgo8dXNlIHhsaW5rOmhyZWY9IiNpbWFnZTBfMjI4XzQ3IiB0cmFuc2Zvcm09InNjYWxlKDAuMDAwNjk0NDQ0IDAuMDAxMTIzNikiLz4KPC9wYXR0ZXJuPgo8aW1hZ2UgaWQ9ImltYWdlMF8yMjhfNDciIHdpZHRoPSIxNDQwIiBoZWlnaHQ9Ijg5MCIgeGxpbms6aHJlZj0iZGF0YTppbWFnZS9wbmc7YmFzZTY0LGlWQk9SdzBLR2dvQUFBQU5TVWhFVWdBQUJhQUFBQU42Q0FNQUFBQlBDeDZKQUFBQWZsQk1WRVVBQUFEcDZPai8vLy8zOS9mejgvUG01dWJuNStmeTh2THg4ZkgxOWZYdjcrOTJkbmJVMHRBd01EQ3dzclMxdGJXN3ZMN2YzdDdGeDhpVGs1TjZlbnJGeGNWSlNVbXNyS3pxNnVxRmhZVnRiVzA5UFQzTHpNMWlZbUpWVlZXZ29LQWtKQ1RaMnRyUDBORzR1Ym0zdDdmVjFkV1ltSmlOalkzdDdPeWxwYVRjLzVjaEFBQUFBWFJTVGxNQVFPYllaZ0FBR245SlJFRlVlTnJzMjlGcWd6QVVnT0VkVWloZWJNRzIyS1FWcjZUNC9rKzRPajFTUjVqWVJrbmQvMkZERHRUYi8wTE5od0FBa2tTZ0FTQlJCQm9BRWtXZ0FTQlJCQm9BRWtXZ0FTQlJjd1B0ZHBuWm9yMFRBRWpMekVDN2JlYjVMcVBRQUJJek05QjdzMWs3QVlDa3pBeTAyYTVNQUNBcEJIb2dBQkJGYVFlbFREaGE2ZG1qakJEb1B3UHR2UURBYlBabWV6Y3JFMnB2KzV0OExTT0JRSCtOL085QVh5NENBTE5aTzlwTkZqcmM1NmNEWFI0ZWxHWVRDRFFBdFZLZ3RkREJQajhkNkVPMzZ2Q1d6cTVkM2JtYkNEUUF0VjZndGRDaFBvY0MzVjVxMDRHdUttZU1xNnB1SXRBQTFNcUJsdHFIK3Z4cW9IdG1rRFZPWW1reXM2UzJ6YTc5NlN5UC9PWHVlbTFYM2hRQytIRWJSQTYwOVQ3d3Y5Y0MvWHVJZlJ6UExWM29vcW9LN1RPQkJqQkR6RUJiWDllQlFzY09kQ05STldaWitlYzExejJQT0FDb0ZRT3QzMjhFQ2gwNzBCS1hNOHM2RmNWSjl3UWFnRm92ME5yblVLRmpCOXJKbEpUT3haeUtQQjhLVGFBQkROWTZxS0o5RGhiNmxVQ1haWGU5N1NPT2IvYXVwcmxwR0lnaXJNU1NieDFtbUhEaXdvSC8vd3ZacitkWGQ2WUJEMDJRemI1WUsrbnRhcTJGN1NLY3B2MzI5V1dhWHI1Kzgxa1c2RVFpUVR6eG85NC9NUHJ4WmF2NWlBSjkyRGNKdjcrb2ZQbnVzL3lvZHlLUkdBMGY5SWdENkI5M2hyNzk3Tk1Ua1Q4c0taRklqSWEvTDlDSC9hQktGdWhFSWpFMjduL1VlN3dDM2UvcmVuOUxnYWVLZ05MVW13Sjk1WkJjc0ZjUzFFRzVtWVBERUROeVc4V1dvTUg5alZHbjkzMUxnYWVLZ05LM20vRm4vSWVPLzVUNHRNZjRYL3l3cEc2dEN5WnZ5blJBZFU2R1VocUZTemZCcWxYU2E5emdxdkI4eFVpR0t2QlNDaWdjaENYWE83a3hNWUgxTHJrQURMRnlXRUJ1dTR1Q0xYSW5FRnhEVDNSSUd2NHkvb3ovZVBHZkhZUC9QT2kxakZyUHVhdE00SUp3QmF5VjR6QzBLUEl3ZGRVbVRaRFpoU3g3cEEwRm11dG9JUXd0bUk0aU1hYkxFdEFoYk43SlUvakJSUmlOdTVDaEw3b0NCU0xqei9nUEduODVMOFl0MERqc29wcHlMaUFiZGl6VkJqQ280ckQwYWJEUXlFQWwwZ2w0a3o0MkVoaFJtRzdCd0pJbzBNSVVyc2pTRlZIZ2xacXRDVFpKMTVDMEl6WXMva2ZMN3RVZU12Nk0vNWp4bHhPZnBZY3QwSjFWV0NlczF2ZEJxOTBvMTR2Z0toQVJzZ2dwdEl1aWZjRmM5UmMxUTYreTJNRFZxb0VTZW5aeWlaTFF1WGZGT3pRZndLOXVrcWJSSU5kN2xwaUl3QXN6V0lONkZXL0duL0VmS1g0VTZsTS83TmhYb0cvVGs3QStjWVo4QW41ZVBHY3VCcVpaRU9ReFFwNWJ6dEdHV29od2pNd08zNnVDNjRPaEJvaEZZUTNIN0dGREpjRzlJTi9CV0tQTGpEL2pQMUQ4Z1NMWGlSOUk3eXZReS9RVTRHbUZEWitHOWpvbGVEakFVUUg1QVlicDViMTNaUG5GVStUMUptdHBiSG9Ga3h3Nm5tWm9BS3ljQzBnZVg3aDMwL0Myc01RaUl1UFArSThYZjV5aHovb3NlbGVCdnZYcDRkaThlL2MwVkJXTEpaU0JpWUMwSitNTkNmc09GelFXdzI2VGhKdkUxbzR3cHFpa0ZXZ0ZsME9IZmNiUTZEdkFsL0FHR1gvR2Y3ajRVWnVsbmZHYjhIWVU2TnZ5aFByTXA4OUFsVXRmM2xkcEN2U21kNHYrbXFVOWh0SUM4T3R1TVpHcjNhNlhSQ0p4SEt6UHAwczU1V09PVHdQK29tNVVhRlpPYllTUzkrQnJoa0Rmb2UwN0hHWDhHZjkvSDMrdlVSOGNrNG1UWWJ3QzdRODRVSjROdzZTYlkraE52WStNUCtNL1Zmd2RvaXU4YnB5dVJBOVhvRkdkRGIvTmdWbXZQWmp2MEIrVWQvT2Y3V3BtZndjWmY4YWY4ZDhGM2tHS1R6bWNyRUtQVjZDN3RUZzlpd3pNZ3FaU1dtMHlWMHFFY0swMW9YUm1Tb0VObEt4Tk9ydGFOUk1UcXZYTy9WcFgxVXhhb0RXUUZYcHpLVXcxcnJWWTJLdDdnaS9jZTdaOUJGUE4zcGE0TkEvcmwxaERhN012c1MyN0MzZWQ4V2Y4LzBuODljL2l4MkpEVjV6d0FEMWdnZGFYd2NwenBKU0kxcFpsRWRHYU1zMnhtSERsTE93eVY3WFJVVnQ4dUZTMXNLRUlOVld0cmhGOXJJUm5vZHdSTkUwZ1U5T3BDWVM3VVovTnhTS282c0Q4MlZabm82UXR4cmE0dmEzUWpGTzdLblNkemF5Sm1KVnR1dHpNZkdyTGxwYnhaL3daUCtNWElaMlZjNWJvUEVFL0dsM2hzdG8vMTAxVFR2OHlrUWVXSThyWVdCVXlRUUtwb1hTQmFqd3NSZWdWV3VXWmNxMkcycld6anNGbzNxaFgrUFh6aUtwMEVxL1pKMkZuRFc0c0thR1g1cnZtSmtBMlRHazR4MlowblBGbi9JK0l2ejBtL3ZiNCtKdlorT0hldjAvcmhPOFNqbGFnQld0OW5qNG5Fb25FN3pIcEdmcU1GWHE0QXQyQm12VTVrVWpzck5EVHVTcjBXQVhhL25qeEJ1SG54Qy8yN3I5SFRSZ000SGpXQjAvUjFsbWhMVmdLS21OMzkvN2Y0QW9IMUI5VVpDNkxPWi9QTnJjc3k1TDc1NXNuNVNtSEVMcVBHNkcvMVRIMGN3VzZYN0dyYi9VUmhCQzZ6L3dyMEZELytFWlQ5Sk1GR3NJdlFUREhRQ09FN3JYb0N2MjlSdWluQ25SM0dhanVNd1lhSVhTMytkZXUzVGNib0o4cjBCQjJkMVRxQldpQ0VFTDNCbnB1eS9GOG14emhqRmVVSHZoZmRmYlpBbTNoRVFkQ2FMSmx2UXo5ZklzY0g3UlQvVVZwbnkzUVlRMlBPQkJDdC9HM3kwQ2ZYU2VFVTl5d25JTEhIbng0Q1RlSXFNUEJqOU1UTTVqT0graGdlNERiRHRzQWJ1Q1JaQ3lQT1VBQlB0VFFzejVEOS9MOCtYeEpIS2pXYTdYaEJDR0VMS1d1SHhMNlZxSGpOQ25rOUVBWEd2eVVqbHU1QWE4WnRVU1JwcjhGdGZnL0RIU3czWXdHZW5PcjBJWFdjYUVpcVl1SWdVZkJkaXlDWGdodG9PdDNvSndFT2xoWFlEKzNKZDVkUVFnUmNoRGwyMFdnZzlyZ0lYUXVBQmlmSEdqREJIaEZPMmdkamIrdVRaL1RsWlUyaGY3NGQ0RSsxbjErb05BRnl6blVsR2FlUUNleHBFQmxuRUNyN1hOanNUenBjL3ZuYWtNUVFrZ0ZiK1ZWb0lkRzZNZ1lveU1vbWJFbUJacnJOQUt2S0laeEZiWGVWNDEzYWxYaEk0SDI5OWxmNkF5R2NTYmI3a2JNRTJndURhOS95eVUvUGVPQUlBanJBZG9GdXFwSWE1TVFoTkNyT3doQ0xrYm94U0tZRHdUYUZFSUlEbHhZYkZLZzFVNlkyNEV1Tkd2bGlYZUF6bGF0akZwdkR3WGEzMmQvb1k4d0tHYThtNlE5Z1JZNjdiNVdYVUlyckFYV1l1NENYWWFrTmRzU2hOQUxDM2dsZm4zYU9MOTkvdHBXL0lPMGxvdEYwK2VMUWhzQnZYc0R6VlhOS05DcTRRdTBWdndMTllYM0NhRll0ZHdwOUlPQmRuMStvTkQ1RGtia2hmdGlKVFQ2YXlyQi9QUWhvU0tkQU04NEVIcHBTaDBQSDBDc2o0d2ZsWEtCYmg0VGRubCtKTkNsMXJIRklZMGJ2a0M3YyswNEdvd2pyY1dyUmtwckZkUWVEZlJ4YzBMQXRlM0dHUzQwaTJDRWRQK3hrT2RyZGhkbjBHdlNXV0tnRVhwcGdUcVEyc3d3eGxaRjBMZGgyZlhaRlRwSmM5MWxocHI4M2tBRGx6c096czFBRjZVMzBMU2hWbzFQMm9BQjcvdDM5ekU1MEJsY0U1TUNuZHdmYUhBUENSZmsrdVNaWndRaDlNb0NkYXo3TEpuK1pFek8rNzllWEc5eDdGS2E4alpDTWhMeC9XZlFrVlFBVUtyR3pVQkhhaVRRTkZwWkVmVUhlci9mdTQvL2RNUWhEZlIwN2cxMEt1UGtOTkI5b2VjbkUzU3k2ZGM1UW9JUWVtbUJxZ2lKR1pNenh0anY2ejFvTjBFejZBa3piYzJPYXdWM0hIRVVVbXNwUElHdXFGVzJXeHhwU2EzRDZBVDl2eDRTNmdSYVlyL3lCYnJJeXp5Nm5LRERab3ZqZEE5Nm01RmFVT0lBamRETE8yekluRWtUejR6UjJnVzZLM1N0Zjg0bDJnNGxtaWZsaEVDRDVMd0V2OEtJMFFtYVUwby9WNzNQQng4Uytnczl2YzlBdGVuK2pXYmNGMmdqUU8zNlFMczNKUVVYTndtcmRUWGoyVG9yY1lKRzZOVWRLekpqY1phUkxNdlo5UmFIbTZDcFpFelVkUlljSXEybnJObXBIZFdxaUJvd0lNbmw2Qm4wckRtQWRuNVMrdVBCUUR2Wnd4ZFZKQWRMeVAxdnVCVm80d0x0WHBWa0xjNTNhN0tNQTFsaW9SRjZkWnMzOHFIYkk0NzhiSUoyZ1c1eEl3QzR6blVCa0V3SmRCNUxBZDVBMThhM09NTG1GcUVUWnhVMG51T3FOMk1tU2czVENnYkpWS2xjZ1AwbENoZG9DR3R1aStNY0ZocWhsN2NPam1wM2RRWnRDeDIyZ2I1WXN6TUZjSjBBVEFpMFlKS0RNeGJvM1hERUU3VTZvMXhzLzhYTGtzWnlYNDI4TENuTzYwWW5NR3duTFFwQ1dydkx1OTZYMy9JS0YrMFFRbDhLZFlTNVpNeit6TSt2ZW9lRGU5QjVDVEF4MExIa01NcmtjVXVYTU9qbjZzd0dKbnJlMTQwRytEMEpFZnJEM2htM3hnM0RVSHpGNnNrTzlJK3hYdW5Zb0RER3Z2OUhuSjZrbks3c3huS1ViVzd1L1pvNHRtU3IwYzY4R2Vkb3lBWGFWN0h5L3ZIcDRlbUhudis1MFZIVU92REJlR3hIWEw1Y3NZSitibi9tNDh1bjVOaCt3L2RYQytoMkxaTUo5UEFqRkZyNVZtOUN5RmE2cjUvQlZPKzhxbDNveDIvdGFpWVQ2UGdhQjVEUnVZSW1oR3psN0JIaFhPKzhPcjdZTjZFL3Z4eVhkajJUQ2ZRWTYyTkNibkVRUXE2Z2l4SHkzS1o2NmRWYm1FeWc4eDgyOXFENTBsaEN5RlVDUGVFQytrM01KOUNuTFk3QlBXaEN5RlpVYXdXOUk0V2VTNkNOM0lXbVFCTkN0aVBpeXRIMnRML1I1aFBvZWt3b2ZBRWhJV1FiTGZZMzlyVUIzZVlUNkxNbE5CV2FFTEtKcHE3UCs5cmVhRzFLZ1U1RVZIcFg3YjB2SjZ5ZXpiTDJwZEN1YnVuVkZWYVkxcGJtQ1hyMHJWWmROTjJyci9wcVZDcDg0ZDZlUlhXb0lNbnFmWlVaR21FUGY5MDA4MmYrL3ozL1pjcjhyVlR0ZW5wQ3VLL2xjNXRRb01mNWswTEJBWTJXRHFGV01YU3hvNnVLbW0wUlZBenA4SGNIQTZ3TEJnSlVQQWFxNGwwVlFhelJGNHhaRUYzTnByQWhNS2JMT2dpK2FLQTNBbU5zZXNRYUVtRzczNFhZVUF5enF2dGpBSHdadzNOUm5INWZNcnkvZTNRUk9KQ20zL1dpMXJZNjgyZitmem4vL2o3ejF6NGtHREtDWFgyRm8wMG8wT2Q3SEVEOVZCejVYMlZPRzFHZkJ1NU5ZbHJCZ1FzK1Q1UTVXZFlnWXZUc0RMTzF2SzA1ZzMxd1A4MTc5K0lIbmVIelNzUU90M1pEdmFJZUQ2ZUhkaE9hR0prTkEwNzBpa0dhY3hXMThBb2M0Y2tiUjc3TW4va3ovOG8vcFNFV2NTN1BYRUgvRTJLYkg2VWhkaVFhYzhJdmFNR1VkaTBwOTJORmpmS24wbWV0aWhvVWxmbzFtcVpDdzF1RHdwYUdwR28xSkVOV3VlWlVQU3BQWjZRbFMrYlAvSm4vcS95TEViUzlQU0ZzVXdwMGFEUW9pZDdLK0tYOTdobkMvSmsvODcvc2pDTnB4a3gvaCtQdHpDalFZT0FzMXM4QlJRSmpWRkJINGZXMHduRHBXcC9xV3MxeFNjWmFmOXZhV2tOWHNPaDBJWFQ5b0pYZVNLQ3NYbFE5U0dPRnJmTnkvamlZUC9PLzJmelJSR1czcTJjREFqMGZoOFBkQWVYOS9UM083YUQvYmNQOGI1c2J5LytRQ1I5TUxWd3ludS8yeG9lN0Q0UVFRaWFFQWswSUlaTkNnU2FFa0VtaFFCTkN5S1JRb0FraFpGSW8wSVNRbit6VXNRQUFBQURBSUgvcmFld29pSmdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21ZcWVPQlFBQUFBQUcrVnRQWTBkQkpHaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFtYTJLbGpBUUFBQUlCQi90YlQyRkVRQVZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOQkE3ZFN3QUFBQUFNTWpmZWhvN0NpS21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQXFkaXBZd0VBQUFDQVFmN1cwOWhSRUFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DSm5icVdBQUFBQUJna0wvMU5IWVVSTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBM0VUaDBMQUFBQUFBenl0NTdHam9LSUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUNwMjZsZ0FBQUFBWUpDLzlUUjJGRVNDQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvSW1kT2hZQUFBQUFHT1J2UFkwZEJSRXdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRHNWUEhBZ0FBQUFDRC9LMm5zYU1nWWtyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGlLblRvV0FBQUFBQmprYnoyTkhRV1JvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaGlwNDRGQUFBQUFBYjVXMDlqUjBFRVRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRUU96VXNRQUFBQURBSUgvcmFld29pSmdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21ZcWVPQlFBQUFBQUcrVnRQWTBkQkpHaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFtYTJLbGpBUUFBQUlCQi90YlQyRkVRQVZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOQkE3ZFN3QUFBQUFNTWpmZWhvN0NpS21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQXFkaXBZd0VBQUFDQVFmN1cwOWhSRUFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DQnBnU05NQ1VvQUdtQkEwd0pXaUFLVUVEVEFrYVlFclFBRk9DSm5icVdBQUFBQUJna0wvMU5IWVVSTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBMHdKV2lBS1VFRFRBa2FZRXJRQUZPQ0JwZ1NOTUNVb0FHbUJBM0VUaDBMQUFBQUFBenl0NTdHam9LSUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUVyUUFGT0NCcGdTTk1DVW9BR21CQTB3SldpQUtVRURUQWthWUtvQkMraFJNQXBHd1NnWUJZTVNBQURvNWgyK1Fwb3ZDQUFBQUFCSlJVNUVya0pnZ2c9PSIvPgo8L2RlZnM+Cjwvc3ZnPgo=",
    'edge_dark' : "data:image/svg+xml;base64,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",
    'opera'   : "data:image/svg+xml;base64,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",
    'opera_dark' : "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTQ0MCIgaGVpZ2h0PSI4OTAiIHZpZXdCb3g9IjAgMCAxNDQwIDg5MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CjxyZWN0IHdpZHRoPSIxNDQwIiBoZWlnaHQ9Ijg5MCIgZmlsbD0idXJsKCNwYXR0ZXJuMCkiLz4KPGxpbmUgeTE9Ijc4LjUiIHgyPSIxNDQwIiB5Mj0iNzguNSIgc3Ryb2tlPSIjRTlFOEU4Ii8+CjxkZWZzPgo8cGF0dGVybiBpZD0icGF0dGVybjAiIHBhdHRlcm5Db250ZW50VW5pdHM9Im9iamVjdEJvdW5kaW5nQm94IiB3aWR0aD0iMSIgaGVpZ2h0PSIxIj4KPHVzZSB4bGluazpocmVmPSIjaW1hZ2UwXzIyOF81NSIgdHJhbnNmb3JtPSJzY2FsZSgwLjAwMDY5NDQ0NCAwLjAwMTEyMzYpIi8+CjwvcGF0dGVybj4KPGltYWdlIGlkPSJpbWFnZTBfMjI4XzU1IiB3aWR0aD0iMTQ0MCIgaGVpZ2h0PSI4OTAiIHhsaW5rOmhyZWY9ImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFCYUFBQUFONkNBTUFBQUJQQ3g2SkFBQUFiMUJNVkVVQUFBQTVSVkVaSFNIcDZPaTR1TGdrTUR5Y29xai8vLytNanBCUlhHZm02T21vcWF0RlVGdXZyNitRbHB2ZDN1Q0VpNUpsYlhUTzBOTzF1YjVyYzN0ZVozQ2dvcU9vcmJKemVvQjVnSVpXWDJqeTlQVEJ4Y21DaDRzaEtUQWNJeXBBUzFVd09EK1ptNTFTVlZqSHlNbXFZcFRDQUFBQUFYUlNUbE1BUU9iWVpnQUFFazVKUkVGVWVOcnMzTkZxNGtBWWdOR2RsR0FTcFZOcVN5K0UyTlMrL3pPdWd6VXNFaU1zV3Y3V2M4REpCTHorRWlhWi9Ia0FJS1EvRHhVQUFRazBRRkFDRFJDVVFBTUVkU0hRNlJlckFFSVRhSUNnQkJvZ0tJRUdDRXFnQVlJNkRYUmYxL1gyZUNMUUFQOW4xNHgyMVp6Y0hHZE5uZzMwdHVSNTIvZjlvZEYzRmVpbXFRQ3VwZmxzRHZhVCtUOHVtbkV5RitoeSs3eXY5SGdYL2JzQy9iUXE0K3JwVEtDWHl3cTRaLzNIWnZINWVyVkFOeWV6UzRVdWg3bEFsejRYMitQa0pOQjE4VFdPaHZwcWhuUkxPYS8yZmM1Wm9JRUpRLzRZK3BmODh1MkJMbWsrREhPQjd1dTZQNWxkRG5SOVZlbDJTcHRYNVNmUXdJUm1XY2JkNXZzRFhlSmMrandiNkhGbFk3eUZ2aHpvb2I2cUlkM1Fxc3U1V3lXQkJpWjg3cW9pdjM5N29FdWhTNTh2QmZwMG1pNnByeXpkVXJ2WXRHbjA3NFZ6TCtjeWVsSUk5K3I1OVhEWVZmTVdvMWlCcm92RCtDTUR2ZTY2dFVBRE0wc2NRN2JFY2M2UWJtamR0VzIzdHNRQlRPbHpNMVM3M0hoSWVFNjZvYmV1VGFudDNnUWFtRElzRjR2bmo4MTczTmZzdGhPdjJVMzVnYS9aUGJabGJCOEZHamlqcjZxWFBNVGNxTEt0Zi9OR2xTK1dPSUQ1c2tiZTZsM1o2ZzBRd05USGt2cmp5VjBGR2lBWW54c0ZDRXFnQVlJU2FJQ2dCQm9nS0lFR0NFcWdBWUlTYUlDZ0JCb2dLSUVHQ0VxZ0FZTGFCem9CRUpCQUF3UWwwQUJCQ1RSQVVBSU5FSlJBQXdRbDBBQkJDVFJBVUFMTlgzYnVaZWRwR0FqRHNMN05tSEdNNC9wUTEzOWNxZUwrTDVLWWNsS3gwd1lLS2pEUFpoS2xpNnhlUlc1aUljU0xra0FMSWNTTGtrQUxJY1NMa2tBTEljU0xlcVZBS3dnaHhMOUt2WGFnNC9SK2RRWnNtMU9VUUFzaC9oOHZIdWlwdksybVE1clNPc3NrZ1JaQy9DMk1yL3hiQW0wbzgvNUFYejZjMEdIUEdHUFNTczJCQVlzZnZYL0Q2bmc0SE50OGUvL0E3VjlPeCtOa0R4QkNpSjhSYVpYd3E0elZ2bXBuTUdKSUsrMEF1NDVzSGc0ME00ZWFkZUlyMHduMG9NL3Z1NEUrdlI4WDJpNUxzSTcwWWtrOUpkRG1lTG9BNXZ6aEFpR0U2QllqV3d5eHB0VVNNWkpyd1QyMnpvdDNnTlBLdDlrelp3T3VJZGQxMEd3ZURmU3N0WXBZOUdmem80RisxL3E4cjlCV3pZekdMZW9wZ1RaSEJwcVRoUkJDOUlvUkxkSHc2ZGxucktnU2xkRnZuSGZZNW9Oam9Fa2xlUFRZZ01aN05KbDJMSEZZN2ZYZUpZNXo2L09vMEFVOXJMUUJHbEw5UUNlc3BzY0RmVHJoTS9zR0lZVG9GS01Va0VWSDBVVEVXREVSNllpdUNyaHFHUnRhd1VzRWVKM09vMmZtNnpSb1dPOElOSW96T3dQZCtqeDA2bDhNaW9IR3FuNmc3WFJjVGVZeVRXMmU3OTcrQjRQUDBobENDSEZUakpoRHNIQXVvNE1JQVB0bENZeVVpTkJGRVVBTWdiY0RiV1kybm9lQlZvUFQ1Ny9GTWU3emRxSG5panZTWVhVQnpLRzVmL3NUdmpDeXhpR0UrS0VZbEFEa2tqQUtOR3N5aHJRWkI1cnBPa0tJR0tnT1FQVFpZUmpvcFhPNko5QnBXYWdmNkVHZmR4ZGFFZTQ0TkFhNHRKbnUzLzRSWDdBRVdnanhZekZ5QWlvd0RIUU9XR1ZxWjhQOFh0SHNDN29DWVZVclZoVFE0eU8rRS8yamdiWjBwUjB2NjdCL0p0QUdIZWRQS3h2VHhWeVhPdXpHN2QrdVBCOEtoQkRpdGhpc0U4SkdvSy9oTEhVajBNRmRXZTBUdW5JR3dQT2NycTN2aWJQQk56cnVEblJrTlFqMDdrS1g3bVh0TzhmZHR6aW1OdFA5UHduZkxLN00wVUFJSVc2S3daNXozSHFDRGc0cnR4Rm9EbWhTcmhFRGJnYWdPV2tEekFWZE9kdzhjZTljNHRDTGZjYWZoT09MWVRINExLcndsUGVnendXTitTQVAwRUtJRzZyMUdiQUpVS05BUjgyQTBXNGM2TXdBWW0xanhDeU1iQUdid1lyUkYvTFhvL0RVVDczSEVSNWNLdWhKaThjVjY0V2ZFbWljanFkMEtNZnlRWjZnaFJDM3hYQ01aaVBRSUozelFoZ0h1Z0tsa3NHV0VHNk9lbkkxYlpnYXNDL1FzWmk5Z1lZZEZmcTg4YUdLNWphalZoYlBDVFRNb1pUREJTeUZGa0lNaXpFT05OamFpSEdnb3lWdkRiYng0b0RHYXNZUXRZczhFL1lGbXVZNm8yLy9wOTdqUHJkQ0swL1pxOFdOTjB0S1V6cE1iM3MzUzVKQ0N5RnVxTytnSTJyNmppN295VDdpdnJSUUczWkoyR0ExSjIzUjdQalVlMG5RWDh3N05rc3EzVUNmTWNaaGJvMDJXOXVOV3VEOCtIYWo4cUtkRU9JbkZmcE9SSmZCUTFoclY3eE8ySlMwanRnVmFNTmNLMm4rUWpic0YwSjhaT2VPVFFBRUFnQUdXb2lGQ0xyL3RQNEdvbFhrNzRaSUdWNjc5bk03SGp0K2ZOdU5GbjdRQWczTUt6N3NGMmhnWGo4UE5BQUNEZEFuMEFCUkFnMFFKZEFBVVFJTkVDWFFBRkVDRFJBbDBBQlJBZzBRSmRBQVVRSU5FRFVDdlFJUU5BSzlBQkFrMEFCUkFnMFFKZEFBVVFJTkVDWFF3TTFPSFFzQUFBQUFEUEszbnNhT2dvZ3BRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ0tuYnFXQUFBQUFCZ2tMLzFOSFlVUklJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnaVowNkZnQUFBQUFZNUc4OWpSMEZFVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRT3hVOGNDQUFBQUFJUDhyYWV4b3lCaVN0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUlxZE9oWUFBQUFBR09SdlBZMGRCWkdnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhR0tuamdVQUFBQUFCdmxiVDJOSFFRUk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RCQTdOU3hBQUFBQU1BZ2YrdHA3Q2lJbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVppcDQ0RkFBQUFBQWI1VzA5alIwRWthSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNacllxV01CQUFBQWdFSCsxdFBZVVJBQlU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwRUR0MUxBQUFBQUF3eU45Nkdqc0tJcVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQ3AyS2xqQVFBQUFJQkIvdGJUMkZFUUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJbWR1cFlBQUFBQUdDUXYvVTBkaFJFd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEY1JPSFFzQUFBQUFEUEszbnNhT2dvZ3BRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ0tuYnFXQUFBQUFCZ2tMLzFOSFlVUklJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnaVowNkZnQUFBQUFZNUc4OWpSMEZFVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRT3hVOGNDQUFBQUFJUDhyYWV4b3lCaVN0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUlxZE9oWUFBQUFBR09SdlBZMGRCWkdnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhSUFwUVFOTUNScGdTdEFBVTRJR21CSTB3SlNnQWFZRURUQWxhR0tuamdVQUFBQUFCdmxiVDJOSFFRUk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RBQVU0SUdtQkkwd0pTZ0FhWUVEVEFsYUlBcFFRTk1DUnBnU3RCQTdOU3hBQUFBQU1BZ2YrdHA3Q2lJbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlFRFRBbGFJQXBRUU5NQ1JwZ1N0QUFVNElHbUJJMHdKU2dBYVlhc0lBZUJhTmdGSXlDVVRBb0FRQ0hzUGhlUXUrblNBQUFBQUJKUlU1RXJrSmdnZz09Ii8+CjwvZGVmcz4KPC9zdmc+Cg==",
    'safari'  : "data:image/svg+xml,%3c!-- Generator: Element Pack Addon --%3e %3csvg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 1920 1080' style='enable-background:new 0 0 1920 1080%3b' xml:space='preserve'%3e%3cstyle type='text/css'%3e.st0%7bfill:%23E6E6E5%3b%7d .st1%7bfill:url(%23SVGID_1_)%3b%7d .st2%7bfill:%23F16059%3b%7d .st3%7bfill:%23FEBF2D%3b%7d .st4%7bfill:%234EB748%3b%7d .st5%7bfill:%23989898%3b%7d .st6%7bfill:white%3b%7d .st7%7bfill:%23FBB03B%3b%7d .st8%7bfill:%23B4B4B4%3b%7d%3c/style%3e%3cg%3e%3cpath class='st0' d='M0%2c0v1080h1920V0H0z M1918%2c1078H2V82h1916V1078z'/%3e%3c/g%3e%3cg%3e%3clinearGradient id='SVGID_1_' gradientUnits='userSpaceOnUse' x1='2' y1='42' x2='1918' y2='42'%3e%3cstop offset='5.618000e-03' style='stop-color:%23EDEBEC'/%3e%3cstop offset='1' style='stop-color:%23EDEBEC%3bstop-opacity:0.8'/%3e%3c/linearGradient%3e%3crect x='2' y='2' class='st1' width='1916' height='80'/%3e%3c/g%3e%3cg id='MacOS'%3e%3ccircle class='st2' cx='47' cy='41.5' r='8'/%3e%3ccircle class='st3' cx='75' cy='41.5' r='8'/%3e%3ccircle class='st4' cx='103' cy='41.5' r='8'/%3e%3c/g%3e%3cg id='Menu_Icon'%3e%3cpath class='st5' d='M1881.9%2c35.9c0-0.5%2c0.2-1%2c0.5-1.3c0.4-0.4%2c0.8-0.5%2c1.3-0.5c0.5%2c0%2c1%2c0.2%2c1.3%2c0.5c0.4%2c0.4%2c0.5%2c0.8%2c0.5%2c1.3 s-0.2%2c1-0.5%2c1.3c-0.4%2c0.4-0.8%2c0.5-1.3%2c0.5c-0.5%2c0-1-0.2-1.3-0.5C1882.1%2c36.9%2c1881.9%2c36.4%2c1881.9%2c35.9z M1883.8%2c40 c-0.5%2c0-1%2c0.2-1.3%2c0.5c-0.4%2c0.4-0.5%2c0.8-0.5%2c1.3s0.2%2c1%2c0.5%2c1.3c0.4%2c0.4%2c0.8%2c0.5%2c1.3%2c0.5c0.5%2c0%2c1-0.2%2c1.3-0.5 c0.4-0.4%2c0.5-0.8%2c0.5-1.3s-0.2-1-0.5-1.3C1884.8%2c40.2%2c1884.3%2c40%2c1883.8%2c40z M1881.9%2c47.8c0-0.5%2c0.2-1%2c0.5-1.3 c0.4-0.4%2c0.8-0.5%2c1.3-0.5c0.5%2c0%2c1%2c0.2%2c1.3%2c0.5c0.4%2c0.4%2c0.5%2c0.8%2c0.5%2c1.3s-0.2%2c1-0.5%2c1.3c-0.4%2c0.4-0.8%2c0.5-1.3%2c0.5 c-0.5%2c0-1-0.2-1.3-0.5C1882.1%2c48.8%2c1881.9%2c48.3%2c1881.9%2c47.8z'/%3e%3c/g%3e%3cpath class='st6' d='M1832%2c62H312c-11%2c0-20-9-20-20v0c0-11%2c9-20%2c20-20h1520c11%2c0%2c20%2c9%2c20%2c20v0C1852%2c53%2c1843%2c62%2c1832%2c62z'/%3e%3cg%3e%3cpath class='st7' d='M1826.7%2c36.6c0.1-0.2%2c0.2-0.3%2c0.4-0.4s0.4-0.1%2c0.5%2c0s0.3%2c0.2%2c0.4%2c0.4l1.5%2c3.1l3.4%2c0.5c0.2%2c0%2c0.4%2c0.1%2c0.5%2c0.3 s0.2%2c0.3%2c0.2%2c0.5s-0.1%2c0.4-0.2%2c0.5l-2.5%2c2.4l0.6%2c3.4c0%2c0.2%2c0%2c0.4-0.1%2c0.5s-0.2%2c0.3-0.4%2c0.3s-0.4%2c0-0.5-0.1l-3.1-1.6l-3.1%2c1.6 c-0.2%2c0.1-0.4%2c0.1-0.5%2c0.1s-0.3-0.2-0.4-0.3s-0.1-0.3-0.1-0.5l0.6-3.4l-2.5-2.4c-0.1-0.1-0.2-0.3-0.2-0.5s0-0.4%2c0.2-0.5 s0.3-0.3%2c0.5-0.3l3.4-0.5L1826.7%2c36.6z'/%3e%3c/g%3e%3cg%3e%3cpath class='st5' d='M323%2c41.5c0.3%2c0%2c0.6%2c0.1%2c0.8%2c0.3s0.3%2c0.5%2c0.3%2c0.8v4.5c0%2c0.3-0.1%2c0.6-0.3%2c0.8s-0.5%2c0.3-0.8%2c0.3h-8.3 c-0.3%2c0-0.6-0.1-0.8-0.3s-0.3-0.5-0.3-0.8v-4.5c0-0.3%2c0.1-0.6%2c0.3-0.8s0.5-0.3%2c0.8-0.3h0.6v-1.7c0-0.6%2c0.2-1.2%2c0.5-1.8 s0.8-1%2c1.3-1.3s1.1-0.5%2c1.8-0.5s1.2%2c0.2%2c1.8%2c0.5s1%2c0.8%2c1.3%2c1.3s0.5%2c1.1%2c0.5%2c1.8v1.7H323z M320.6%2c41.5v-1.7c0-0.5-0.2-0.9-0.5-1.2 s-0.7-0.5-1.2-0.5s-0.9%2c0.2-1.2%2c0.5s-0.5%2c0.7-0.5%2c1.2v1.7H320.6z'/%3e%3c/g%3e%3cg id='Page_Navigation'%3e%3cg%3e%3cpath class='st8' d='M246.9%2c33.7c1%2c0.4%2c1.8%2c1%2c2.6%2c1.7l1.2-1.2c0.2-0.2%2c0.3-0.2%2c0.6-0.2s0.4%2c0.1%2c0.6%2c0.2s0.2%2c0.3%2c0.2%2c0.6v4.4 c0%2c0.2-0.1%2c0.4-0.2%2c0.6s-0.3%2c0.2-0.6%2c0.2h-4.4c-0.2%2c0-0.4-0.1-0.6-0.2s-0.2-0.3-0.2-0.6s0.1-0.4%2c0.2-0.6l1.4-1.4 c-0.5-0.5-1.1-0.8-1.7-1.1s-1.3-0.4-2-0.4c-1%2c0-1.9%2c0.2-2.8%2c0.7s-1.5%2c1.2-2.1%2c2s-0.8%2c1.8-0.8%2c2.8s0.2%2c1.9%2c0.7%2c2.8s1.2%2c1.5%2c2%2c2 s1.8%2c0.7%2c2.8%2c0.7c0.7%2c0%2c1.3-0.1%2c2-0.3s1.2-0.6%2c1.7-1c0.1-0.1%2c0.2-0.1%2c0.3-0.1s0.2%2c0%2c0.3%2c0.1l1.3%2c1.3c0.1%2c0.1%2c0.1%2c0.2%2c0.1%2c0.3 s0%2c0.2-0.1%2c0.3c-0.7%2c0.7-1.6%2c1.2-2.5%2c1.6s-1.9%2c0.6-3%2c0.6c-1.5%2c0-2.9-0.4-4.1-1.1s-2.3-1.7-3-3s-1.1-2.6-1.1-4.1s0.4-2.9%2c1.1-4.1 s1.7-2.3%2c3-3s2.6-1.1%2c4.1-1.1C244.9%2c33.1%2c245.9%2c33.3%2c246.9%2c33.7z'/%3e%3c/g%3e%3cg%3e%3cpath class='st8' d='M160.5%2c49.8c-0.2%2c0.2-0.4%2c0.3-0.7%2c0.3s-0.5-0.1-0.7-0.3l-7.6-7.6c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5%2c0.3-0.7 l7.6-7.6c0.2-0.2%2c0.4-0.3%2c0.7-0.3s0.5%2c0.1%2c0.7%2c0.3l0.9%2c0.9c0.2%2c0.2%2c0.3%2c0.4%2c0.3%2c0.7s-0.1%2c0.5-0.3%2c0.7l-4.7%2c4.5h11.2 c0.3%2c0%2c0.5%2c0.1%2c0.7%2c0.3s0.3%2c0.4%2c0.3%2c0.7v1.3c0%2c0.3-0.1%2c0.5-0.3%2c0.7s-0.4%2c0.3-0.7%2c0.3h-11.2l4.7%2c4.5c0.2%2c0.2%2c0.3%2c0.4%2c0.3%2c0.7 s-0.1%2c0.5-0.3%2c0.7L160.5%2c49.8z'/%3e%3c/g%3e%3cg%3e%3cpath class='st8' d='M196.6%2c33.3c0.2-0.2%2c0.4-0.3%2c0.7-0.3s0.5%2c0.1%2c0.7%2c0.3l7.6%2c7.6c0.2%2c0.2%2c0.3%2c0.4%2c0.3%2c0.7s-0.1%2c0.5-0.3%2c0.7 l-7.6%2c7.6c-0.2%2c0.2-0.4%2c0.3-0.7%2c0.3s-0.5-0.1-0.7-0.3l-0.9-0.9c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5%2c0.3-0.7l4.7-4.5h-11.2 c-0.3%2c0-0.5-0.1-0.7-0.3s-0.3-0.4-0.3-0.7v-1.3c0-0.3%2c0.1-0.5%2c0.3-0.7s0.4-0.3%2c0.7-0.3h11.2l-4.7-4.5c-0.2-0.2-0.3-0.4-0.3-0.7 s0.1-0.5%2c0.3-0.7L196.6%2c33.3z'/%3e%3c/g%3e%3c/g%3e%3c/svg%3e",
    'laptop'  : "data:image/svg+xml;base64,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"
}
export default df_frames;