(function ($) {

    df_datatable_init();

    function df_datatable_init() {
        var selectors = document.querySelectorAll('.difl_advanced_data_table');
        [].forEach.call(selectors, function (selector, index) {
            var tableElement = selector.querySelector('.df-advanced-table');
            var optionSetttings = JSON.parse(selector.querySelector('.df_adt_container').dataset.options);
            var itemSelector = '.difl_advanced_data_table_' + index;
            var languagName = (optionSetttings.multi_lang_enable && optionSetttings.multi_lang_name) ? optionSetttings.multi_lang_name : 'English';
        
            const options = {
                // UI Theme Defaults
                searching: optionSetttings.adt_search,
                paging: optionSetttings.adt_paging,
                ordering: optionSetttings.adt_order,
                info: optionSetttings.adt_info,
                // scrollX: optionSetttings.adt_scroll_x,
                responsive: true,
                language: {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.15/i18n/"+ languagName +".json"
                }
            };

            $(itemSelector + ' .df-advanced-table').DataTable(
                options
            );
        });
    }
})(jQuery);
